"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UseField = void 0;
exports.getUseField = getUseField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/use_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function UseFieldComp(props) {
  var _props$component;
  const {
    field,
    propsToForward
  } = (0, _hooks.useFieldFromProps)(props);
  const ComponentToRender = (_props$component = props.component) !== null && _props$component !== void 0 ? _props$component : 'input';

  // Children prevails over anything else provided.
  if (props.children) {
    return props.children(field);
  }
  if (ComponentToRender === 'input') {
    return /*#__PURE__*/_react.default.createElement(ComponentToRender, (0, _extends2.default)({
      type: field.type,
      onChange: field.onChange,
      value: field.value
    }, propsToForward, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(ComponentToRender, (0, _extends2.default)({
    field
  }, propsToForward, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 10
    }
  }));
}
const UseField = exports.UseField = /*#__PURE__*/_react.default.memo(UseFieldComp);

/**
 * Get a <UseField /> component providing some common props for all instances.
 * @param partialProps Partial props to apply to all <UseField /> instances
 *
 * @example
 *
 * // All the "MyUseField" are TextFields
 * const MyUseField = getUseField({ component: TextField });
 *
 * // JSX
 * <Form>
 *   <MyUseField path="textField_0" />
 *   <MyUseField path="textField_1" />
 *   <MyUseField path="textField_2" />
 * </Form>
 */
function getUseField(partialProps) {
  return function (props) {
    const componentProps = {
      ...partialProps,
      ...props
    };
    return /*#__PURE__*/_react.default.createElement(UseField, (0, _extends2.default)({}, componentProps, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 12
      }
    }));
  };
}