"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSettingsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _settings_logic = require("./settings_logic");
var _settings_panel = require("./settings_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/settings/default_settings_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Callout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.callout.title', {
    defaultMessage: 'Individual settings management'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 3
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.callout.body', {
  defaultMessage: 'You can also enable or disable this feature for a specific index on the index’s configuration page.'
}));
const DefaultSettingsFlyout = ({
  closeFlyout
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    makeRequest,
    setPipeline
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    defaultPipeline,
    hasNoChanges,
    isLoading,
    pipelineState
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const {
    extract_binary_content: extractBinaryContent,
    reduce_whitespace: reduceWhitespace,
    run_ml_inference: runMLInference
  } = pipelineState;
  // Reference the first focusable element in the flyout for accessibility on click or Enter key action either Reset or Save button
  const firstFocusInFlyoutRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    size: "s",
    paddingSize: "l",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.h2.defaultSettingsLabel', {
    defaultMessage: 'Default Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: Callout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.defaultSettingsFlyout.body.description.label",
    defaultMessage: "These settings apply to all new Elasticsearch indices created by Search ingestion mechanisms. For API ingest-based indices, remember to include the pipeline when you ingest documents. These features are powered by {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        href: _doc_links.docLinks.ingestPipelines,
        target: "_blank",
        ref: firstFocusInFlyoutRef,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.body.description.ingestPipelinesLink.link', {
        defaultMessage: 'ingest pipelines'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.description', {
      defaultMessage: 'Extract searchable content from binary files, like PDFs and Word documents.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contactExtraction.label', {
      defaultMessage: 'Content extraction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      extract_binary_content: !pipelineState.extract_binary_content
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.title', {
      defaultMessage: 'Deployment wide content extraction'
    }),
    value: extractBinaryContent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whiteSpaceReduction.description', {
      defaultMessage: 'Whitespace reduction will strip your full-text content of whitespace by default.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.label', {
      defaultMessage: 'Whitespace reduction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      reduce_whitespace: !pipelineState.reduce_whitespace
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide whitespace reduction'
    }),
    value: reduceWhitespace,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.description', {
      defaultMessage: 'ML Inference Pipelines will run as part of your pipelines. You will have to configure processors for each index individually on its pipelines page.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.label', {
      defaultMessage: 'ML Inference'
    }),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      href: _doc_links.docLinks.mlDocumentEnrichment,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.link', {
      defaultMessage: 'Learn more about document enrichment with ML'
    })),
    onChange: () => setPipeline({
      ...pipelineState,
      run_ml_inference: !pipelineState.run_ml_inference
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide ML Inference Pipelines extraction'
    }),
    value: runMLInference,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => closeFlyout(),
    "data-test-subj": 'entSearchContentSettingsCancelButtonButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => {
      var _firstFocusInFlyoutRe;
      setPipeline(defaultPipeline);
      (_firstFocusInFlyoutRe = firstFocusInFlyoutRef.current) === null || _firstFocusInFlyoutRe === void 0 ? void 0 : _firstFocusInFlyoutRe.focus();
    },
    "data-test-subj": 'entSearchContentSettingsResetButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.resetButtonLabel', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => {
      var _firstFocusInFlyoutRe2;
      makeRequest(pipelineState);
      (_firstFocusInFlyoutRe2 = firstFocusInFlyoutRef.current) === null || _firstFocusInFlyoutRe2 === void 0 ? void 0 : _firstFocusInFlyoutRe2.focus();
    },
    "data-test-subj": 'entSearchContentSettingsSaveButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))))));
};
exports.DefaultSettingsFlyout = DefaultSettingsFlyout;