"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StartModelButton = exports.SelectedModel = exports.NoModelSelected = exports.ModelStartingButton = exports.ModelSelect = exports.ModelDeployingButton = exports.DeployModelButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ml = require("../../../../../../../common/types/ml");
var _license_badge = require("./license_badge");
var _model_select_logic = require("./model_select_logic");
var _model_select_option = require("./model_select_option");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/model_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeployModelButton = ({
  onClick,
  modelId,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    disabled: disabled,
    color: "primary",
    iconType: "download",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployButton.ariaLabel', {
      defaultMessage: 'Deploy {modelId} model',
      values: {
        modelId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployButton.label', {
    defaultMessage: 'Deploy'
  }));
};
exports.DeployModelButton = DeployModelButton;
const ModelDeployingButton = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: true,
    color: "primary",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.deployingButton.label', {
    defaultMessage: 'Deploying'
  }))));
};
exports.ModelDeployingButton = ModelDeployingButton;
const StartModelButton = ({
  onClick,
  modelId,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    disabled: disabled,
    color: "success",
    iconType: "play",
    size: "s",
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startButton.ariaLabel', {
      defaultMessage: 'Start {modelId} model',
      values: {
        modelId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startButton.label', {
    defaultMessage: 'Start'
  }));
};
exports.StartModelButton = StartModelButton;
const ModelStartingButton = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: true,
    color: "success",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.startingButton.label', {
    defaultMessage: 'Starting'
  }))));
};
exports.ModelStartingButton = ModelStartingButton;
const NoModelSelected = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  color: "subdued",
  style: {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 148,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  textAlign: "center",
  color: "subdued",
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 156,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.noModelSelectedPanel.text', {
  defaultMessage: 'Select an available model to add to your inference pipeline'
})));
exports.NoModelSelected = NoModelSelected;
const SelectedModel = model => {
  const {
    createModel,
    startModel
  } = (0, _kea.useActions)(_model_select_logic.ModelSelectLogic);
  const {
    areActionButtonsDisabled
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const getSelectedModelAnnouncement = selectedModel => selectedModel.isPlaceholder ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelNotDeployedAnnouncement', {
    defaultMessage: '{modelId} model selected but not deployed',
    values: {
      modelId: selectedModel.modelId
    }
  }) : selectedModel.deploymentState === _ml.MlModelDeploymentState.NotDeployed ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelNotStartedAnnouncement', {
    defaultMessage: '{modelId} model selected but not started',
    values: {
      modelId: selectedModel.modelId
    }
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.selectedModelAnnouncement', {
    defaultMessage: '{modelId} model selected',
    values: {
      modelId: selectedModel.modelId
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    title: "Selected model",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderLive, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, getSelectedModelAnnouncement(model)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, model.title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, model.modelId)), model.description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 15
    }
  }, model.description)), model.licenseType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_license_badge.LicenseBadge, {
    licenseType: model.licenseType,
    modelDetailsPageUrl: model.modelDetailsPageUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 17
    }
  }))), (model.isPlaceholder || [_ml.MlModelDeploymentState.Downloading, _ml.MlModelDeploymentState.NotDeployed, _ml.MlModelDeploymentState.Starting].includes(model.deploymentState)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "aria-live": "polite",
    "aria-atomic": "false",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }, model.isPlaceholder ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(DeployModelButton, {
    onClick: () => createModel(model.modelId),
    modelId: model.modelId,
    disabled: areActionButtonsDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 25
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 29
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.modelSelect.modelNotDeployedError', {
    defaultMessage: 'Model must be deployed before use.'
  })))))) : model.deploymentState === _ml.MlModelDeploymentState.Downloading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(ModelDeployingButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 23
    }
  })) : model.deploymentState === _ml.MlModelDeploymentState.NotDeployed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(StartModelButton, {
    onClick: () => startModel(model.modelId),
    modelId: model.modelId,
    disabled: areActionButtonsDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 23
    }
  })) : model.deploymentState === _ml.MlModelDeploymentState.Starting ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(ModelStartingButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 23
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)))))));
};
exports.SelectedModel = SelectedModel;
const ModelSelect = () => {
  const {
    addInferencePipelineModal: {
      configuration,
      indexName
    },
    ingestionMethod,
    isLoading,
    selectableModels,
    selectedModel
  } = (0, _kea.useValues)(_model_select_logic.ModelSelectLogic);
  const {
    setInferencePipelineConfiguration
  } = (0, _kea.useActions)(_model_select_logic.ModelSelectLogic);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    modelID,
    pipelineName,
    isPipelineNameUserSupplied
  } = configuration;
  const rowHeight = (0, _eui.useIsWithinMaxBreakpoint)('s') ? euiTheme.base * 8 : euiTheme.base * 6;
  const maxVisibleOptions = 4.5;
  const [listHeight, setListHeight] = (0, _react.useState)(maxVisibleOptions * rowHeight);
  const getModelSelectOptionProps = models => (models !== null && models !== void 0 ? models : []).map(model => ({
    label: model.modelId,
    checked: model.modelId === modelID ? 'on' : undefined,
    data: {
      ...model
    }
  }));
  const onChange = options => {
    var _selectedModelOption$, _selectedModelOption$2, _selectedModelOption$3;
    const selectedModelOption = options.find(option => option.checked === 'on');
    setInferencePipelineConfiguration({
      ...configuration,
      inferenceConfig: undefined,
      modelID: (_selectedModelOption$ = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.modelId) !== null && _selectedModelOption$ !== void 0 ? _selectedModelOption$ : '',
      isModelPlaceholderSelected: (_selectedModelOption$2 = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.isPlaceholder) !== null && _selectedModelOption$2 !== void 0 ? _selectedModelOption$2 : false,
      fieldMappings: undefined,
      pipelineName: isPipelineNameUserSupplied ? pipelineName : indexName + '-' + (0, _utils.normalizeModelName)((_selectedModelOption$3 = selectedModelOption === null || selectedModelOption === void 0 ? void 0 : selectedModelOption.data.modelId) !== null && _selectedModelOption$3 !== void 0 ? _selectedModelOption$3 : '')
    });
  };
  const onSearchChange = (_, matchingOptions) => {
    setListHeight(Math.min(maxVisibleOptions, matchingOptions.length) * rowHeight);
  };
  const renderOption = option => {
    const {
      data,
      ...optionExclData
    } = option;
    const flattenedOption = {
      ...optionExclData,
      ...data
    };
    return /*#__PURE__*/_react.default.createElement(_model_select_option.ModelSelectOption, (0, _extends2.default)({}, flattenedOption, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 335,
        columnNumber: 12
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-configureInferencePipeline-selectTrainedModel`,
    options: getModelSelectOptionProps(selectableModels),
    singleSelection: "always",
    listProps: {
      bordered: true,
      rowHeight,
      onFocusBadge: false
    },
    height: listHeight,
    onChange: onChange,
    renderOption: renderOption,
    isLoading: isLoading,
    searchable: true,
    searchProps: {
      onChange: onSearchChange
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 7
    }
  }, selectedModel ? /*#__PURE__*/_react.default.createElement(SelectedModel, (0, _extends2.default)({}, selectedModel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 26
    }
  })) : /*#__PURE__*/_react.default.createElement(NoModelSelected, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 65
    }
  })));
};
exports.ModelSelect = ModelSelect;