"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantTelemetryEvents = exports.assistantSettingToggledEvent = exports.assistantQuickPrompt = exports.assistantMessageSentEvent = exports.assistantInvokedEvent = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assistantInvokedEvent = exports.assistantInvokedEvent = {
  eventType: _types.AssistantEventTypes.AssistantInvoked,
  schema: {
    invokedBy: {
      type: 'keyword',
      _meta: {
        description: 'Invocation method',
        optional: false
      }
    }
  }
};
const assistantMessageSentEvent = exports.assistantMessageSentEvent = {
  eventType: _types.AssistantEventTypes.AssistantMessageSent,
  schema: {
    role: {
      type: 'keyword',
      _meta: {
        description: 'Conversation role',
        optional: false
      }
    },
    actionTypeId: {
      type: 'keyword',
      _meta: {
        description: 'Kibana connector type',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'LLM model',
        optional: true
      }
    },
    provider: {
      type: 'keyword',
      _meta: {
        description: 'OpenAI provider',
        optional: true
      }
    },
    isEnabledKnowledgeBase: {
      type: 'boolean',
      _meta: {
        description: 'Is knowledge base enabled'
      }
    }
  }
};
const assistantQuickPrompt = exports.assistantQuickPrompt = {
  eventType: _types.AssistantEventTypes.AssistantQuickPrompt,
  schema: {
    promptTitle: {
      type: 'keyword',
      _meta: {
        description: 'Title of the quick prompt',
        optional: false
      }
    }
  }
};
const assistantSettingToggledEvent = exports.assistantSettingToggledEvent = {
  eventType: _types.AssistantEventTypes.AssistantSettingToggled,
  schema: {
    alertsCountUpdated: {
      type: 'boolean',
      _meta: {
        description: 'Did alerts count update',
        optional: true
      }
    },
    assistantStreamingEnabled: {
      type: 'boolean',
      _meta: {
        description: 'Is streaming enabled',
        optional: true
      }
    }
  }
};
const assistantTelemetryEvents = exports.assistantTelemetryEvents = [assistantInvokedEvent, assistantMessageSentEvent, assistantQuickPrompt, assistantSettingToggledEvent];