"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerformanceContextProvider = PerformanceContextProvider;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _apmRumCore = require("@elastic/apm-rum-core");
var _reactRouterDom = require("react-router-dom");
var _use_performance_context = require("./use_performance_context");
var _measure_interaction = require("./measure_interaction");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-ebt-tools/src/performance_metrics/context/performance_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PerformanceContextProvider({
  children
}) {
  const [isRendered, setIsRendered] = (0, _react.useState)(false);
  const location = (0, _reactRouterDom.useLocation)();
  const interaction = (0, _react.useMemo)(() => (0, _measure_interaction.measureInteraction)(location.pathname), [location.pathname]);
  _react.default.useEffect(() => {
    (0, _apmRumCore.afterFrame)(() => {
      setIsRendered(true);
    });
    return () => {
      setIsRendered(false);
      performance.clearMeasures(location.pathname);
    };
  }, [location.pathname]);
  const api = (0, _react.useMemo)(() => ({
    onPageReady(eventData) {
      if (isRendered) {
        interaction.pageReady(eventData);
      }
    },
    onPageRefreshStart() {
      interaction.pageRefreshStart();
    }
  }), [isRendered, interaction]);
  return /*#__PURE__*/_react.default.createElement(_use_performance_context.PerformanceContext.Provider, {
    value: api,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 10
    }
  }, children);
}
// dynamic import
// eslint-disable-next-line import/no-default-export
var _default = exports.default = PerformanceContextProvider;