"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelContext = exports.Panel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _flyout_panels = require("./flyout_panels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/flyout_panels/flyout_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flyoutPanelContext = /*#__PURE__*/(0, _react.createContext)({
  registerFooter: () => {},
  registerContent: () => {}
});
const Panel = ({
  children,
  width,
  className = '',
  backgroundColor,
  border,
  ...rest
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  const [config, setConfig] = (0, _react.useState)({
    hasContent: false,
    hasFooter: false
  });
  const {
    addPanel
  } = (0, _flyout_panels.useFlyoutPanelsContext)();
  const registerContent = (0, _react.useCallback)(() => {
    setConfig(prev => {
      return {
        ...prev,
        hasContent: true
      };
    });
  }, []);
  const registerFooter = (0, _react.useCallback)(() => {
    setConfig(prev => {
      if (!prev.hasContent) {
        throw new Error('You need to add a <FlyoutPanels.Content /> when you add a <FlyoutPanels.Footer />');
      }
      return {
        ...prev,
        hasFooter: true
      };
    });
  }, []);
  (0, _react.useLayoutEffect)(() => {
    const removePanel = addPanel({
      width
    });
    return removePanel;
  }, [width, addPanel]);
  const dynamicStyles = {};
  if (width) {
    dynamicStyles.flexBasis = `${width}%`;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.flyoutColumn,
    style: dynamicStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(flyoutPanelContext.Provider, {
    value: {
      registerContent,
      registerFooter
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    css: [styles.flyoutPanel, backgroundColor === 'euiPageBackground' && styles.pageBackground, backgroundColor === 'euiEmptyShade' && styles.emptyShade, border === 'left' && styles.leftBorder, border === 'right' && styles.rightBorder, config.hasContent && styles.withContent]
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), children)));
};
exports.Panel = Panel;
const useFlyoutPanelContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelContext);
  if (ctx === undefined) {
    throw new Error('useFlyoutPanel() must be used within a <flyoutPanelContext.Provider />');
  }
  return ctx;
};
exports.useFlyoutPanelContext = useFlyoutPanelContext;
const componentStyles = {
  flyoutColumn: themeContext => (0, _react2.css)({
    height: '100%',
    overflow: 'hidden',
    [(0, _eui.euiMaxBreakpoint)(themeContext, 'm')]: {
      height: 'auto'
    }
  }),
  flyoutPanel: ({
    euiTheme
  }) => (0, _react2.css)({
    height: '100%',
    overflowY: 'auto',
    padding: euiTheme.size.l
  }),
  pageBackground: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.body
  }),
  emptyShade: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.emptyShade
  }),
  leftBorder: ({
    euiTheme
  }) => (0, _react2.css)({
    borderLeft: euiTheme.border.thin
  }),
  rightBorder: ({
    euiTheme
  }) => (0, _react2.css)({
    borderRight: euiTheme.border.thin
  }),
  withContent: (0, _react2.css)({
    padding: 0,
    overflowY: 'hidden',
    display: 'flex',
    flexDirection: 'column'
  })
};