"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterTerms = void 0;
var _esQuery = require("@kbn/es-query");
var _fieldFormatsCommon = require("@kbn/field-formats-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createFilterTerms = (aggConfig, key, params) => {
  const field = aggConfig.params.field;
  const indexPattern = aggConfig.aggConfigs.indexPattern;
  if (key === '__other__') {
    const terms = params.terms;
    const phraseFilter = (0, _esQuery.buildPhrasesFilter)(field, terms, indexPattern);
    phraseFilter.meta.negate = true;
    const filters = [phraseFilter];
    if (terms.some(term => term === _fieldFormatsCommon.MISSING_TOKEN)) {
      filters.push((0, _esQuery.buildExistsFilter)(field, indexPattern));
    }
    return filters;
  } else if (key === _fieldFormatsCommon.MISSING_TOKEN) {
    const existsFilter = (0, _esQuery.buildExistsFilter)(field, indexPattern);
    existsFilter.meta.negate = true;
    return existsFilter;
  }
  return (0, _esQuery.buildPhraseFilter)(field, key, indexPattern);
};
exports.createFilterTerms = createFilterTerms;