"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowShareModal = ShowShareModal;
exports.showPublicUrlSwitch = void 0;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-utils-plugin/public");
var _dashboard_backup_service = require("../../../services/dashboard_backup_service");
var _kibana_services = require("../../../services/kibana_services");
var _get_dashboard_capabilities = require("../../../utils/get_dashboard_capabilities");
var _urls = require("../../../utils/urls");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _dashboard_router = require("../../dashboard_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_app/top_nav/share/show_share_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showFilterBarId = 'showFilterBar';
const showPublicUrlSwitch = anonymousUserCapabilities => {
  if (!anonymousUserCapabilities.dashboard_v2) return false;
  const dashboard = anonymousUserCapabilities.dashboard_v2;
  return !!dashboard.show;
};
exports.showPublicUrlSwitch = showPublicUrlSwitch;
function ShowShareModal({
  isDirty,
  asExport,
  anchorElement,
  savedObjectId,
  dashboardTitle
}) {
  var _getDashboardBackupSe, _g2;
  if (!_kibana_services.shareService) return;
  const EmbedUrlParamExtension = ({
    setParamValue
  }) => {
    const [urlParamsSelectedMap, seturlParamsSelectedMap] = (0, _react.useState)({
      showFilterBar: true
    });
    const checkboxes = [{
      id: _dashboard_router.dashboardUrlParams.showTopMenu,
      label: _dashboard_app_strings.shareModalStrings.getTopMenuCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showQueryInput,
      label: _dashboard_app_strings.shareModalStrings.getQueryCheckbox()
    }, {
      id: _dashboard_router.dashboardUrlParams.showTimeFilter,
      label: _dashboard_app_strings.shareModalStrings.getTimeFilterCheckbox()
    }, {
      id: showFilterBarId,
      label: _dashboard_app_strings.shareModalStrings.getFilterBarCheckbox()
    }];
    const handleChange = param => {
      const newSelectedMap = {
        ...urlParamsSelectedMap,
        [param]: !urlParamsSelectedMap[param]
      };
      const urlParamValues = {
        [_dashboard_router.dashboardUrlParams.showTopMenu]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTopMenu],
        [_dashboard_router.dashboardUrlParams.showQueryInput]: newSelectedMap[_dashboard_router.dashboardUrlParams.showQueryInput],
        [_dashboard_router.dashboardUrlParams.showTimeFilter]: newSelectedMap[_dashboard_router.dashboardUrlParams.showTimeFilter],
        [_dashboard_router.dashboardUrlParams.hideFilterBar]: !newSelectedMap[showFilterBarId]
      };
      seturlParamsSelectedMap(newSelectedMap);
      setParamValue(urlParamValues);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckboxGroup, {
      options: checkboxes,
      idToSelectedMap: urlParamsSelectedMap,
      onChange: handleChange,
      legend: {
        children: _dashboard_app_strings.shareModalStrings.getCheckboxLegend()
      },
      "data-test-subj": "embedUrlParamExtension",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    });
  };
  const unsavedDashboardState = (_getDashboardBackupSe = (0, _dashboard_backup_service.getDashboardBackupService)().getState(savedObjectId)) !== null && _getDashboardBackupSe !== void 0 ? _getDashboardBackupSe : {};
  const hasPanelChanges = unsavedDashboardState.panels !== undefined;
  const unsavedDashboardStateForLocator = {
    ...unsavedDashboardState,
    controlGroupInput: unsavedDashboardState.controlGroupInput,
    references: unsavedDashboardState.references
  };
  const locatorParams = {
    dashboardId: savedObjectId,
    preserveSavedFilters: true,
    refreshInterval: undefined,
    // We don't share refresh interval externally
    viewMode: 'view',
    // For share locators we always load the dashboard in view mode
    useHash: false,
    timeRange: _kibana_services.dataService.query.timefilter.timefilter.getTime(),
    ...unsavedDashboardStateForLocator
  };
  let _g = (0, _public.getStateFromKbnUrl)('_g', window.location.href);
  if ((_g2 = _g) !== null && _g2 !== void 0 && _g2.filters && _g.filters.length === 0) {
    _g = (0, _lodash.omit)(_g, 'filters');
  }
  const baseUrl = (0, _public.setStateToKbnUrl)('_g', _g, undefined, window.location.href);
  const shareableUrl = (0, _public.setStateToKbnUrl)(_urls.DASHBOARD_STATE_STORAGE_KEY, unsavedDashboardStateForLocator, {
    useHash: false,
    storeInHashQuery: true
  }, (0, _public.unhashUrl)(baseUrl));
  const allowShortUrl = (0, _get_dashboard_capabilities.getDashboardCapabilities)().createShortUrl;
  _kibana_services.shareService.toggleShareContextMenu({
    isDirty,
    anchorElement,
    allowShortUrl,
    shareableUrl,
    asExport,
    objectId: savedObjectId,
    objectType: 'dashboard',
    objectTypeMeta: {
      title: _i18n.i18n.translate('dashboard.share.shareModal.title', {
        defaultMessage: 'Share this dashboard'
      }),
      config: {
        link: {
          draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
            color: "warning",
            "data-test-subj": "DashboardDraftModeCopyLinkCallOut",
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "dashboard.share.shareModal.draftModeCallout.title",
              defaultMessage: "Unsaved changes",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 172,
                columnNumber: 17
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 168,
              columnNumber: 13
            }
          }, hasPanelChanges ? allowShortUrl ? _dashboard_app_strings.shareModalStrings.getDraftSharePanelChangesWarning() : _dashboard_app_strings.shareModalStrings.getSnapshotShareWarning() : _dashboard_app_strings.shareModalStrings.getDraftShareWarning('link'))
        },
        embed: {
          draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
            color: "warning",
            "data-test-subj": "DashboardDraftModeEmbedCallOut",
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "dashboard.share.shareModal.draftModeCallout.title",
              defaultMessage: "Unsaved changes",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 192,
                columnNumber: 17
              }
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 13
            }
          }, hasPanelChanges ? _dashboard_app_strings.shareModalStrings.getEmbedSharePanelChangesWarning() : _dashboard_app_strings.shareModalStrings.getDraftShareWarning('embed')),
          embedUrlParamExtensions: [{
            paramName: 'embed',
            component: EmbedUrlParamExtension
          }],
          computeAnonymousCapabilities: showPublicUrlSwitch
        },
        integration: {
          export: {
            pdfReports: {
              draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                color: "warning",
                iconType: "warning",
                title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                  id: "dashboard.exports.pdfReports.warning.title",
                  defaultMessage: "Unsaved changes",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 219,
                    columnNumber: 21
                  }
                }),
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 215,
                  columnNumber: 17
                }
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "dashboard.exports.pdfReports.postURLWatcherMessage.unsavedChanges",
                defaultMessage: "URL may change if you upgrade Kibana.",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 225,
                  columnNumber: 19
                }
              }))
            },
            imageReports: {
              draftModeCallOut: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
                color: "warning",
                iconType: "warning",
                title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                  id: "dashboard.exports.imageReports.warning.title",
                  defaultMessage: "Unsaved changes",
                  __self: this,
                  __source: {
                    fileName: _jsxFileName,
                    lineNumber: 238,
                    columnNumber: 21
                  }
                }),
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 234,
                  columnNumber: 17
                }
              }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "dashboard.exports.imageReports.postURLWatcherMessage.unsavedChanges",
                defaultMessage: "URL may change if you upgrade Kibana.",
                __self: this,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 244,
                  columnNumber: 19
                }
              }))
            }
          }
        }
      }
    },
    sharingData: {
      title: dashboardTitle || _i18n.i18n.translate('dashboard.share.defaultDashboardTitle', {
        defaultMessage: 'Dashboard [{date}]',
        values: {
          date: (0, _moment.default)().toISOString(true)
        }
      }),
      locatorParams: {
        id: _deeplinksAnalytics.DASHBOARD_APP_LOCATOR,
        params: locatorParams
      }
    },
    shareableUrlLocatorParams: {
      locator: _kibana_services.shareService.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR),
      params: locatorParams
    }
  });
}