"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleSystemColorModeChange = handleSystemColorModeChange;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _eui = require("@elastic/eui");
var _rxjs = require("rxjs");
var _coreThemeBrowserInternal = require("@kbn/core-theme-browser-internal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/handle_system_colormode_change.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const doSyncWithSystem = (userSettings = {
  darkMode: 'space_default'
}, uiSettingsDarkModeValue = 'disabled') => {
  const {
    darkMode: userProfileDarkModeValue = 'space_default'
  } = userSettings;
  if (userProfileDarkModeValue.toUpperCase() === 'SYSTEM') {
    return true;
  }
  if (userProfileDarkModeValue.toUpperCase() === 'SPACE_DEFAULT' && uiSettingsDarkModeValue.toUpperCase() === 'SYSTEM') {
    return true;
  }
  return false;
};
const isUnauthenticated = http => {
  const {
    anonymousPaths
  } = http;
  return anonymousPaths.isAnonymous(window.location.pathname);
};
const doHandle = async ({
  http,
  coreStart,
  uiSettings
}) => {
  if (!(0, _coreThemeBrowserInternal.browsersSupportsSystemTheme)()) return false;
  if (isUnauthenticated(http)) return false;
  const userProfile = await coreStart.userProfile.getCurrent({
    dataPath: 'userSettings'
  });
  const {
    userSettings
  } = userProfile.data;
  if (!doSyncWithSystem(userSettings, uiSettings.get('theme:darkMode'))) return false;
  return true;
};
async function handleSystemColorModeChange({
  notifications,
  uiSettings,
  coreStart,
  stop$,
  http
}) {
  if (!(await doHandle({
    http,
    uiSettings,
    coreStart
  }))) {
    return;
  }
  let currentDarkModeValue;
  const matchMedia = window.matchMedia('(prefers-color-scheme: dark)');
  const onDarkModeChange = ({
    matches: isDarkMode
  }) => {
    if (currentDarkModeValue === undefined) {
      // The current value can only be set on page reload as that's the moment when
      // we actually apply set the dark/light color mode of the page.
      currentDarkModeValue = isDarkMode;
    } else if (currentDarkModeValue !== isDarkMode) {
      notifications.toasts.addInfo({
        title: _i18n.i18n.translate('core.ui.chrome.appearanceChange.successNotificationTitle', {
          defaultMessage: 'System color mode updated'
        }),
        text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('core.ui.chrome.appearanceChange.successNotificationText', {
          defaultMessage: 'Reload the page to see the changes'
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 118,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          onClick: () => window.location.reload(),
          "data-test-subj": "windowReloadButton",
          autoFocus: true,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 19
          }
        }, _i18n.i18n.translate('core.ui.chrome.appearanceChange.requiresPageReloadButtonLabel', {
          defaultMessage: 'Reload page'
        }))))))
      }, {
        toastLifeTimeMs: Infinity
      } // leave it on until discard or page reload
      );
    }
  };
  onDarkModeChange(matchMedia);
  matchMedia.addEventListener('change', onDarkModeChange);
  stop$.pipe((0, _rxjs.take)(1)).subscribe(() => {
    matchMedia.removeEventListener('change', onDarkModeChange);
  });
}