"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverSuggestions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _constants = require("../constants");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
var _options_list_popover_empty_message = require("./options_list_popover_empty_message");
var _options_list_popover_suggestion_badge = require("./options_list_popover_suggestion_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_suggestions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OptionsListPopoverSuggestions = ({
  showOnlySelected
}) => {
  const {
    componentApi,
    displaySettings: {
      hideExists
    }
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _use_memo_css.useMemoCss)(optionListPopoverSuggestionsStyles);
  const [sort, searchString, existsSelected, searchTechnique, selectedOptions, fieldName, invalidSelections, availableOptions, totalCardinality, loading, fieldFormatter, allowExpensiveQueries] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.sort$, componentApi.searchString$, componentApi.existsSelected$, componentApi.searchTechnique$, componentApi.selectedOptions$, componentApi.fieldName$, componentApi.invalidSelections$, componentApi.availableOptions$, componentApi.totalCardinality$, componentApi.dataLoading$, componentApi.fieldFormatter, componentApi.parentApi.allowExpensiveQueries$);
  const listRef = (0, _react.useRef)(null);
  const canLoadMoreSuggestions = (0, _react.useMemo)(() => allowExpensiveQueries && totalCardinality && !showOnlySelected // && searchString.valid
  ? (availableOptions !== null && availableOptions !== void 0 ? availableOptions : []).length < Math.min(totalCardinality, _constants.MAX_OPTIONS_LIST_REQUEST_SIZE) : false, [availableOptions, totalCardinality, showOnlySelected, allowExpensiveQueries]);
  const suggestions = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = showOnlySelected ? selectedOptions : availableOptions) !== null && _ref !== void 0 ? _ref : [];
  }, [availableOptions, selectedOptions, showOnlySelected]);
  const existsSelectableOption = (0, _react.useMemo)(() => {
    if (hideExists || !existsSelected && (showOnlySelected || (suggestions === null || suggestions === void 0 ? void 0 : suggestions.length) === 0)) return;
    return {
      key: 'exists-option',
      checked: existsSelected ? 'on' : undefined,
      label: _options_list_strings.OptionsListStrings.controlAndPopover.getExists(),
      css: styles.optionsListExistsFilter,
      'data-test-subj': 'optionsList-control-selection-exists'
    };
  }, [suggestions, existsSelected, showOnlySelected, hideExists, styles]);
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)([]); // will be set in following useEffect
  (0, _react.useEffect)(() => {
    /* This useEffect makes selectableOptions responsive to search, show only selected, and clear selections */
    const options = suggestions.map(suggestion => {
      var _fieldFormatter, _suggestion;
      if (typeof suggestion !== 'object') {
        // this means that `showOnlySelected` is true, and doc count is not known when this is the case
        suggestion = {
          value: suggestion
        };
      }
      return {
        key: String(suggestion.value),
        label: String((_fieldFormatter = fieldFormatter(suggestion.value)) !== null && _fieldFormatter !== void 0 ? _fieldFormatter : suggestion.value),
        checked: (selectedOptions !== null && selectedOptions !== void 0 ? selectedOptions : []).includes(suggestion.value) ? 'on' : undefined,
        'data-test-subj': `optionsList-control-selection-${suggestion.value}`,
        className: showOnlySelected && invalidSelections.has(suggestion.value) ? 'optionsList__selectionInvalid' : 'optionsList__validSuggestion',
        append: !showOnlySelected && (_suggestion = suggestion) !== null && _suggestion !== void 0 && _suggestion.docCount ? /*#__PURE__*/_react.default.createElement(_options_list_popover_suggestion_badge.OptionsListPopoverSuggestionBadge, {
          documentCount: suggestion.docCount,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 13
          }
        }) : undefined
      };
    });
    if (canLoadMoreSuggestions) {
      options.push({
        key: 'loading-option',
        'data-test-subj': 'optionslist--canLoadMore',
        label: _options_list_strings.OptionsListStrings.popover.getLoadingMoreMessage(),
        isGroupLabel: true,
        css: styles.loadMore
      });
    } else if (options.length === _constants.MAX_OPTIONS_LIST_REQUEST_SIZE) {
      options.push({
        key: 'no-more-option',
        label: _options_list_strings.OptionsListStrings.popover.getAtEndOfOptionsMessage(),
        isGroupLabel: true,
        css: styles.noMoreOptions
      });
    }
    setSelectableOptions(existsSelectableOption ? [existsSelectableOption, ...options] : options);
  }, [suggestions, availableOptions, showOnlySelected, selectedOptions, invalidSelections, existsSelectableOption, canLoadMoreSuggestions, fieldFormatter, styles]);
  const loadMoreOptions = (0, _react.useCallback)(() => {
    var _listRef$current;
    const listbox = (_listRef$current = listRef.current) === null || _listRef$current === void 0 ? void 0 : _listRef$current.querySelector('.euiSelectableList__list');
    if (!listbox) return;
    const {
      scrollTop,
      scrollHeight,
      clientHeight
    } = listbox;
    if (scrollTop + clientHeight >= scrollHeight - parseInt(euiTheme.size.xxl, 10)) {
      // reached the "bottom" of the list, where euiSizeXXL acts as a "margin of error" so that the user doesn't
      // have to scroll **all the way** to the bottom in order to load more options
      componentApi.setRequestSize(Math.min(totalCardinality, _constants.MAX_OPTIONS_LIST_REQUEST_SIZE));
      componentApi.loadMoreSubject.next(); // trigger refetch with loadMoreSubject
    }
  }, [componentApi, euiTheme.size.xxl, totalCardinality]);
  const renderOption = (0, _react.useCallback)((option, searchStringValue) => {
    if (!allowExpensiveQueries || searchTechnique === 'exact') return option.label;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: option.key === 'exists-option' ? '' : searchStringValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    }, option.label);
  }, [searchTechnique, allowExpensiveQueries]);
  (0, _react.useEffect)(() => {
    const container = listRef.current;
    if (!loading && canLoadMoreSuggestions) {
      container === null || container === void 0 ? void 0 : container.addEventListener('scroll', loadMoreOptions, true);
      return () => {
        container === null || container === void 0 ? void 0 : container.removeEventListener('scroll', loadMoreOptions, true);
      };
    }
  }, [loadMoreOptions, loading, canLoadMoreSuggestions]);
  (0, _react.useEffect)(() => {
    var _listRef$current2;
    // scroll back to the top when changing the sorting or the search string
    const listbox = (_listRef$current2 = listRef.current) === null || _listRef$current2 === void 0 ? void 0 : _listRef$current2.querySelector('.euiSelectableList__list');
    listbox === null || listbox === void 0 ? void 0 : listbox.scrollTo({
      top: 0
    });
  }, [sort, searchString]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "optionsList--scrollListener",
    ref: listRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: selectableOptions,
    renderOption: option => renderOption(option, searchString),
    listProps: {
      onFocusBadge: false
    },
    "aria-label": _options_list_strings.OptionsListStrings.popover.getSuggestionsAriaLabel(fieldName, selectableOptions.length),
    emptyMessage: /*#__PURE__*/_react.default.createElement(_options_list_popover_empty_message.OptionsListPopoverEmptyMessage, {
      showOnlySelected: showOnlySelected,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 25
      }
    }),
    onChange: (newSuggestions, event, changedOption) => {
      componentApi.makeSelection(changedOption.key, showOnlySelected);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, list => list)));
};
exports.OptionsListPopoverSuggestions = OptionsListPopoverSuggestions;
const optionListPopoverSuggestionsStyles = {
  optionsListExistsFilter: ({
    euiTheme
  }) => (0, _react2.css)`
    font-style: italic;
    font-weight: ${euiTheme.font.weight.medium};
  `,
  loadMore: ({
    euiTheme
  }) => (0, _react2.css)`
    text-align: center;
    padding: ${euiTheme.size.m};
    font-style: italic;
    height: ${euiTheme.size.xxl} !important;
  `,
  noMoreOptions: ({
    euiTheme
  }) => (0, _react2.css)({
    textAlign: 'center',
    fontSize: euiTheme.size.m,
    height: 'auto !important',
    color: euiTheme.colors.textSubdued,
    padding: euiTheme.size.m
  })
};