"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonacoEditorOutput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _codeEditor = require("@kbn/code-editor");
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _vectorTile = require("@mapbox/vector-tile");
var _pbf = _interopRequireDefault(require("pbf"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _monaco = require("@kbn/monaco");
var _utils = require("./utils");
var _contexts = require("../../contexts");
var _monaco_editor_output_actions_provider = require("./monaco_editor_output_actions_provider");
var _hooks = require("./hooks");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/editor/monaco_editor_output.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    actions
  } = (0, _styles.useActionStyles)();
  return {
    outputActions: (0, _react2.css)`
      ${actions}

      // For IE11
      min-width: ${euiTheme.size.l};
    `
  };
};
const useStatusCodeClassNames = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => ({
    monacoStatusCodeLinePrimary: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.primary, 0.1)};
      `,
    monacoStatusCodeLineNumberPrimary: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.primary, 0.5)};
      `,
    monacoStatusCodeLineSuccess: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.success, 0.1)};
      `,
    monacoStatusCodeLineNumberSuccess: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.success, 0.5)};
      `,
    monacoStatusCodeLineDefault: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.lightShade, 0.1)};
      `,
    monacoStatusCodeLineNumberDefault: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.lightShade, 0.5)};
      `,
    monacoStatusCodeLineWarning: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.warning, 0.1)};
      `,
    monacoStatusCodeLineNumberWarning: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.warning, 0.5)};
      `,
    monacoStatusCodeLineDanger: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.danger, 0.1)};
      `,
    monacoStatusCodeLineNumberDanger: (0, _css.css)`
        background-color: ${(0, _eui.transparentize)(euiTheme.colors.danger, 0.5)};
      `
  }), [euiTheme.colors.primary, euiTheme.colors.success, euiTheme.colors.lightShade, euiTheme.colors.warning, euiTheme.colors.danger]);
};
const MonacoEditorOutput = () => {
  const context = (0, _contexts.useServicesContext)();
  const {
    services: {
      notifications
    }
  } = context;
  const {
    settings: readOnlySettings
  } = (0, _contexts.useEditorReadContext)();
  const {
    lastResult: {
      data
    }
  } = (0, _contexts.useRequestReadContext)();
  const [value, setValue] = (0, _react.useState)('');
  const [mode, setMode] = (0, _react.useState)('text');
  const divRef = (0, _react.useRef)(null);
  const {
    setupResizeChecker,
    destroyResizeChecker
  } = (0, _hooks.useResizeCheckerUtils)();
  const monacoEditorOutputStyles = useStyles();
  const statusCodeClassNames = useStatusCodeClassNames();
  const highlightedLinesClassName = (0, _styles.useHighlightedLinesClassName)();
  const lineDecorations = (0, _react.useRef)(null);
  const actionsProvider = (0, _react.useRef)(null);
  const [editorActionsCss, setEditorActionsCss] = (0, _react.useState)({});
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    const provider = new _monaco_editor_output_actions_provider.MonacoEditorOutputActionsProvider(editor, setEditorActionsCss, highlightedLinesClassName);
    actionsProvider.current = provider;
    setupResizeChecker(divRef.current, editor);
    lineDecorations.current = editor.createDecorationsCollection();
  }, [highlightedLinesClassName, setupResizeChecker]);
  const editorWillUnmountCallback = (0, _react.useCallback)(() => {
    destroyResizeChecker();
  }, [destroyResizeChecker]);
  (0, _react.useEffect)(() => {
    var _lineDecorations$curr;
    // Clean up any existing line decorations
    (_lineDecorations$curr = lineDecorations.current) === null || _lineDecorations$curr === void 0 ? void 0 : _lineDecorations$curr.clear();
    if (data) {
      const isMultipleRequest = data.length > 1;
      setMode(isMultipleRequest ? _monaco.CONSOLE_OUTPUT_LANG_ID : (0, _utils.languageForContentType)(data[0].response.contentType));
      setValue(data.map(result => {
        const {
          value: newValue,
          contentType
        } = result.response;
        let editorOutput;
        if (readOnlySettings.tripleQuotes && (0, _utils.isJSONContentType)(contentType)) {
          editorOutput = (0, _utils.safeExpandLiteralStrings)(newValue);
        } else if ((0, _utils.isMapboxVectorTile)(contentType)) {
          const vectorTile = new _vectorTile.VectorTile(new _pbf.default(newValue));
          const vectorTileJson = (0, _utils.convertMapboxVectorTileToJson)(vectorTile);
          editorOutput = (0, _utils.safeExpandLiteralStrings)(vectorTileJson);
        } else {
          editorOutput = newValue;
        }
        return editorOutput;
      }).join('\n'));
      if (isMultipleRequest) {
        var _lineDecorations$curr2, _actionsProvider$curr;
        // If there are multiple responses, add decorations for their status codes
        const decorations = (0, _utils.getStatusCodeDecorations)(data, statusCodeClassNames);
        (_lineDecorations$curr2 = lineDecorations.current) === null || _lineDecorations$curr2 === void 0 ? void 0 : _lineDecorations$curr2.set(decorations);
        // Highlight first line of the output editor
        (_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.selectFirstLine();
      }
    } else {
      setValue('');
    }
  }, [readOnlySettings, data, value, statusCodeClassNames]);
  const copyOutputCallback = (0, _react.useCallback)(async () => {
    var _actionsProvider$curr2;
    const selectedText = await ((_actionsProvider$curr2 = actionsProvider.current) === null || _actionsProvider$curr2 === void 0 ? void 0 : _actionsProvider$curr2.getParsedOutput());
    try {
      var _window$navigator;
      if (!((_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.clipboard)) {
        throw new Error('Could not copy to clipboard!');
      }
      await window.navigator.clipboard.writeText(selectedText);
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('console.outputPanel.copyOutputToast', {
          defaultMessage: 'Selected output copied to clipboard'
        })
      });
    } catch (e) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('console.outputPanel.copyOutputToastFailedMessage', {
          defaultMessage: 'Could not copy selected output to clipboard'
        })
      });
    }
  }, [notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        width: 100%;
        height: 100%;
      `,
    ref: divRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: monacoEditorOutputStyles.outputActions,
    responsive: false,
    style: editorActionsCss,
    justifyContent: "center",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('console.outputPanel.copyOutputButtonTooltipContent', {
      defaultMessage: 'Click to copy to clipboard'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copyClipboard",
    onClick: copyOutputCallback,
    "data-test-subj": "copyOutputButton",
    "aria-label": _i18n.i18n.translate('console.outputPanel.copyOutputButtonTooltipAriaLabel', {
      defaultMessage: 'Click to copy to clipboard'
    }),
    iconSize: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: 'ConAppOutputTextarea',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('console.monaco.outputTextarea', {
    defaultMessage: 'Dev Tools Console output'
  }))), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: 'consoleMonacoOutput',
    languageId: mode,
    value: value,
    fullWidth: true,
    editorDidMount: editorDidMountCallback,
    editorWillUnmount: editorWillUnmountCallback,
    enableFindAction: true,
    enableCustomContextMenu: true,
    options: {
      readOnly: true,
      fontSize: readOnlySettings.fontSize,
      wordWrap: readOnlySettings.wrapMode === true ? 'on' : 'off',
      theme: _monaco.CONSOLE_OUTPUT_THEME_ID,
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 7
    }
  }));
};
exports.MonacoEditorOutput = MonacoEditorOutput;