"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CISBenchmarkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _cis_eks_logo = _interopRequireDefault(require("../assets/icons/cis_eks_logo.svg"));
var _google_cloud_logo = _interopRequireDefault(require("../assets/icons/google_cloud_logo.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cis_benchmark_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getBenchmarkIdIconType = type => {
  switch (type) {
    case 'cis_eks':
      return _cis_eks_logo.default;
    case 'cis_azure':
      return 'logoAzure';
    case 'cis_aws':
      return 'logoAWS';
    case 'cis_gcp':
      return _google_cloud_logo.default;
    case 'cis_k8s':
      return 'logoKubernetes';
  }
};
const CISBenchmarkIcon = props => {
  const iconType = getBenchmarkIdIconType(props.type);
  if (!iconType) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: props.name,
    type: iconType,
    size: props.size || 'xl',
    css: props.style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.CISBenchmarkIcon = CISBenchmarkIcon;