"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_ASSIGNEES_VALUE = exports.AssigneesFilterPopover = void 0;
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_is_user_typing = require("../../common/use_is_user_typing");
var _use_suggest_user_profiles = require("../../containers/user_profiles/use_suggest_user_profiles");
var _use_available_owners = require("../app/use_available_owners");
var _use_cases_context = require("../cases_context/use_cases_context");
var _empty_message = require("../user_profiles/empty_message");
var _no_matches = require("../user_profiles/no_matches");
var _sort = require("../user_profiles/sort");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/assignees_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NO_ASSIGNEES_VALUE = exports.NO_ASSIGNEES_VALUE = null;
const AssigneesFilterPopoverComponent = ({
  selectedAssignees: selectedAssigneesUids,
  currentUserProfile,
  isLoading,
  onSelectionChange
}) => {
  const {
    owner: owners
  } = (0, _use_cases_context.useCasesContext)();
  const hasOwners = owners.length > 0;
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)(['read']);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const onChange = (0, _react.useCallback)(users => {
    const sortedUsers = (0, _sort.orderAssigneesIncludingNone)(currentUserProfile, users);
    onSelectionChange({
      filterId: 'assignees',
      selectedOptionKeys: sortedUsers.map(user => {
        var _user$uid;
        return (_user$uid = user === null || user === void 0 ? void 0 : user.uid) !== null && _user$uid !== void 0 ? _user$uid : null;
      })
    });
  }, [currentUserProfile, onSelectionChange]);
  const selectedStatusMessage = (0, _react.useCallback)(selectedCount => i18n.TOTAL_ASSIGNEES_FILTERED(selectedCount), []);
  const onSearchChange = (0, _react.useCallback)(term => {
    setSearchTerm(term);
    onContentChange(term);
  }, [onContentChange]);
  const {
    data: userProfiles,
    isLoading: isLoadingSuggest
  } = (0, _use_suggest_user_profiles.useSuggestUserProfiles)({
    name: searchTerm,
    owners: hasOwners ? owners : availableOwners,
    onDebounce
  });
  const limitReachedMessage = (0, _react.useCallback)(limit => i18n.MAX_SELECTED_FILTER(limit, 'assignees'), []);
  const searchResultProfiles = (0, _react.useMemo)(() => {
    var _bringCurrentUserToFr;
    const sortedUsers = (_bringCurrentUserToFr = (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles)) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
    if ((0, _lodash.isEmpty)(searchTerm)) {
      return [null, ...sortedUsers];
    }
    return sortedUsers;
  }, [currentUserProfile, userProfiles, searchTerm]);
  const selectedAssignees = selectedAssigneesUids.map(uuid => {
    // this is the "no assignees" option
    if (uuid === null) return null;
    const userProfile = searchResultProfiles.find(user => (user === null || user === void 0 ? void 0 : user.uid) === uuid);
    return userProfile;
  }).filter(userProfile => userProfile !== undefined); // Filter out profiles that no longer exists
  const isLoadingData = isLoading || isLoadingSuggest;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesPopover, {
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelStyle: {
      width: 400
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "options-filter-popover-button-assignees",
      iconType: "arrowDown",
      onClick: togglePopover,
      isLoading: isLoadingData,
      isSelected: isPopoverOpen,
      hasActiveFilters: selectedAssignees.length > 0,
      numActiveFilters: selectedAssignees.length,
      "aria-label": i18n.FILTER_ASSIGNEES_ARIA_LABEL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, i18n.ASSIGNEES),
    selectableProps: {
      onChange,
      onSearchChange,
      selectedStatusMessage,
      options: searchResultProfiles,
      selectedOptions: selectedAssignees,
      isLoading: isLoadingData || isUserTyping,
      height: 'full',
      searchPlaceholder: i18n.SEARCH_USERS,
      clearButtonLabel: i18n.CLEAR_FILTERS,
      emptyMessage: /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 25
        }
      }),
      noMatchesMessage: !isUserTyping && !isLoadingData ? /*#__PURE__*/_react.default.createElement(_no_matches.NoMatches, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 63
        }
      }) : /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 79
        }
      }),
      limit: _constants.MAX_ASSIGNEES_FILTER_LENGTH,
      limitReachedMessage,
      singleSelection: false,
      nullOptionLabel: i18n.NO_ASSIGNEES
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }));
};
AssigneesFilterPopoverComponent.displayName = 'AssigneesFilterPopover';
const AssigneesFilterPopover = exports.AssigneesFilterPopover = /*#__PURE__*/_react.default.memo(AssigneesFilterPopoverComponent);