"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Element = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Element {
  constructor(config) {
    /** The name of the Element. This must match the name of the function that is used to create the `type: render` object  */
    (0, _defineProperty2.default)(this, "name", void 0);
    /** A more friendly name for the Element */
    (0, _defineProperty2.default)(this, "displayName", void 0);
    /** The type of the Element */
    (0, _defineProperty2.default)(this, "type", void 0);
    /** The name of the EUI icon to display in the element menu */
    (0, _defineProperty2.default)(this, "icon", void 0);
    /** A sentence or few about what this Element does */
    (0, _defineProperty2.default)(this, "help", void 0);
    /** A default expression that allows Canvas to render the Element */
    (0, _defineProperty2.default)(this, "expression", void 0);
    (0, _defineProperty2.default)(this, "filter", void 0);
    /** The width of the Element.  Default is 500. */
    (0, _defineProperty2.default)(this, "width", void 0);
    /** The height of the Element.  Default is 300 */
    (0, _defineProperty2.default)(this, "height", void 0);
    const {
      name,
      icon,
      displayName,
      type,
      expression,
      filter,
      help,
      width,
      height
    } = config;
    this.name = name;
    this.displayName = displayName || name;
    this.icon = icon || 'empty';
    this.help = help || '';
    if (!config.expression) {
      throw new Error('Element types must have a default expression');
    }
    this.type = type;
    this.expression = expression;
    this.filter = filter;
    this.width = width || 500;
    this.height = height || 300;
  }
}
exports.Element = Element;