"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withUnconnectedElementsLoadedTelemetry = exports.withElementsLoadedTelemetry = exports.WorkpadLoadedWithErrorsMetric = exports.WorkpadLoadedMetric = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _ui_metric = require("../../lib/ui_metric");
var _workpad = require("../../state/selectors/workpad");
var _resolved_args = require("../../state/selectors/resolved_args");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_app/workpad_telemetry.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadLoadedMetric = exports.WorkpadLoadedMetric = 'workpad-loaded';
const WorkpadLoadedWithErrorsMetric = exports.WorkpadLoadedWithErrorsMetric = 'workpad-loaded-with-errors';
// TODO: Build out full workpad types
/**
  Individual Page of a Workpad
 */

/**
 A canvas workpad object
 */

/**
 Collection of resolved elements
 */

function areAllElementsInResolvedArgs(workpad, resolvedArgs) {
  const resolvedArgsElements = Object.keys(resolvedArgs);
  const workpadElements = workpad.pages.reduce((reduction, page) => {
    return [...reduction, ...page.elements.map(element => element.id)];
  }, []);
  return workpadElements.every(element => resolvedArgsElements.includes(element));
}
const withUnconnectedElementsLoadedTelemetry = (Component, trackMetric = _ui_metric.trackCanvasUiMetric) => function ElementsLoadedTelemetry(props) {
  const {
    workpad
  } = props;
  const [currentWorkpadId, setWorkpadId] = (0, _react.useState)(undefined);
  const [hasReported, setHasReported] = (0, _react.useState)(false);
  const telemetryElementCounts = (0, _reactRedux.useSelector)(state => (0, _workpad.getElementCounts)(state), _reactRedux.shallowEqual);
  const telemetryResolvedArgs = (0, _reactRedux.useSelector)(state => (0, _resolved_args.getArgs)(state), _reactFastCompare.default);
  const resolvedArgsAreForWorkpad = areAllElementsInResolvedArgs(workpad, telemetryResolvedArgs);
  const {
    error,
    pending
  } = telemetryElementCounts;
  const resolved = resolvedArgsAreForWorkpad && pending === 0;
  (0, _react.useEffect)(() => {
    if (workpad.id !== currentWorkpadId) {
      const workpadElementCount = workpad.pages.reduce((reduction, page) => reduction + page.elements.length, 0);
      setWorkpadId(workpad.id);
      setHasReported(workpadElementCount === 0 || resolved);
    } else if (!hasReported && resolved) {
      if (error > 0) {
        trackMetric(_ui_metric.METRIC_TYPE.LOADED, [WorkpadLoadedMetric, WorkpadLoadedWithErrorsMetric]);
      } else {
        trackMetric(_ui_metric.METRIC_TYPE.LOADED, WorkpadLoadedMetric);
      }
      setHasReported(true);
    }
  }, [currentWorkpadId, hasReported, error, workpad.id, resolved, workpad.pages]);
  return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 12
    }
  }));
};
exports.withUnconnectedElementsLoadedTelemetry = withUnconnectedElementsLoadedTelemetry;
const withElementsLoadedTelemetry = Component => withUnconnectedElementsLoadedTelemetry(Component);
exports.withElementsLoadedTelemetry = withElementsLoadedTelemetry;