"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Asset = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _confirm_modal = require("../confirm_modal");
var _clipboard = require("../clipboard");
var _download = require("../download");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/asset_manager/asset.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getCopyAssetTooltip: () => _i18n.i18n.translate('xpack.canvas.asset.copyAssetTooltip', {
    defaultMessage: 'Copy id to clipboard'
  }),
  getCreateImageTooltip: () => _i18n.i18n.translate('xpack.canvas.asset.createImageTooltip', {
    defaultMessage: 'Create image element'
  }),
  getDeleteAssetTooltip: () => _i18n.i18n.translate('xpack.canvas.asset.deleteAssetTooltip', {
    defaultMessage: 'Delete'
  }),
  getDownloadAssetTooltip: () => _i18n.i18n.translate('xpack.canvas.asset.downloadAssetTooltip', {
    defaultMessage: 'Download'
  }),
  getThumbnailAltText: () => _i18n.i18n.translate('xpack.canvas.asset.thumbnailAltText', {
    defaultMessage: 'Asset thumbnail'
  }),
  getConfirmModalButtonLabel: () => _i18n.i18n.translate('xpack.canvas.asset.confirmModalButtonLabel', {
    defaultMessage: 'Remove'
  }),
  getConfirmModalMessageText: () => _i18n.i18n.translate('xpack.canvas.asset.confirmModalDetail', {
    defaultMessage: 'Are you sure you want to remove this asset?'
  }),
  getConfirmModalTitle: () => _i18n.i18n.translate('xpack.canvas.asset.confirmModalTitle', {
    defaultMessage: 'Remove Asset'
  })
};
const Asset = ({
  asset,
  onCreate,
  onDelete
}) => {
  const {
    success
  } = (0, _services.useNotifyService)();
  const [isConfirmModalVisible, setIsConfirmModalVisible] = (0, _react.useState)(false);
  const onCopy = result => result && success(`Copied '${asset.id}' to clipboard`);
  const confirmModal = /*#__PURE__*/_react.default.createElement(_confirm_modal.ConfirmModal, {
    isOpen: isConfirmModalVisible,
    title: strings.getConfirmModalTitle(),
    message: strings.getConfirmModalMessageText(),
    confirmButtonText: strings.getConfirmModalButtonLabel(),
    onConfirm: () => {
      setIsConfirmModalVisible(false);
      onDelete(asset);
    },
    onCancel: () => setIsConfirmModalVisible(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  });
  const createImage = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "asset-create-image",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getCreateImageTooltip(),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "vector",
    "aria-label": strings.getCreateImageTooltip(),
    onClick: () => onCreate(asset.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })));
  const downloadAsset = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "asset-download",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getDownloadAssetTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_download.Download, {
    fileName: asset.id,
    content: asset.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "sortDown",
    "aria-label": strings.getDownloadAssetTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }))));
  const copyAsset = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getCopyAssetTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
    content: asset.id,
    onCopy: onCopy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "copyClipboard",
    "aria-label": strings.getCopyAssetTooltip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }))));
  const deleteAsset = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.getDeleteAssetTooltip(),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    "aria-label": strings.getDeleteAssetTooltip(),
    onClick: () => setIsConfirmModalVisible(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  })));
  const thumbnail = /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasAsset__thumb canvasCheckered",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    className: "canvasAsset__img",
    size: "original",
    url: asset.value,
    fullScreenIconColor: "dark",
    alt: strings.getThumbnailAltText(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }));
  const assetLabel = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "eui-textBreakAll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textBreakAll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, asset.id), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("small", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }, "(", Math.round(asset.value.length / 1024), " kb)"))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: asset.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "canvasAsset",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, thumbnail, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }), assetLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    justifyContent: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, createImage, downloadAsset, copyAsset, deleteAsset)), isConfirmModalVisible ? confirmModal : null);
};
exports.Asset = Asset;