"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockApmPluginStorybook = MockApmPluginStorybook;
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _common2 = require("@kbn/observability-plugin/common");
var _use_kibana_ui_settings = require("@kbn/observability-shared-plugin/public/hooks/use_kibana_ui_settings");
var _url_service = require("@kbn/share-plugin/common/url_service");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _history = require("history");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _rxjs = require("rxjs");
var _apm_route_config = require("../../components/routing/apm_route_config");
var _create_call_apm_api = require("../../services/rest/create_call_apm_api");
var _apm_service_context = require("../apm_service/apm_service_context");
var _mock_time_range_metadata_context_provider = require("../time_range_metadata/mock_time_range_metadata_context_provider");
var _time_range_metadata_context = require("../time_range_metadata/time_range_metadata_context");
var _apm_plugin_context = require("./apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/apm_plugin/mock_apm_plugin_storybook.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const uiSettings = {
  [_use_kibana_ui_settings.UI_SETTINGS.TIMEPICKER_QUICK_RANGES]: [{
    from: 'now/d',
    to: 'now/d',
    display: 'Today'
  }, {
    from: 'now/w',
    to: 'now/w',
    display: 'This week'
  }],
  [_use_kibana_ui_settings.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS]: {
    from: 'now-15m',
    to: 'now'
  },
  [_use_kibana_ui_settings.UI_SETTINGS.TIMEPICKER_REFRESH_INTERVAL_DEFAULTS]: {
    pause: false,
    value: 100000
  },
  [_common2.enableInspectEsQueries]: false
};
const urlService = new _url_service.UrlService({
  navigate: async () => {},
  getUrl: async ({
    app,
    path
  }, {
    absolute
  }) => {
    return `${absolute ? 'http://localhost:8888' : ''}/app/${app}${path}`;
  },
  shortUrls: () => ({
    get: () => {}
  })
});
const locator = urlService.locators.create(new _public2.MlLocatorDefinition());
const mockPlugin = {
  ml: {
    locator
  },
  data: {
    query: {
      timefilter: {
        timefilter: {
          setTime: () => {},
          getTime: () => ({})
        }
      }
    }
  },
  share: {
    url: {
      locators: {
        get: jest.fn()
      }
    }
  }
};
const mockCore = {
  application: {
    capabilities: {
      apm: {},
      ml: {},
      savedObjectsManagement: {}
    },
    currentAppId$: new _rxjs.Observable(),
    getUrlForApp: appId => '',
    navigateToUrl: url => {}
  },
  chrome: {
    docTitle: {
      change: () => {}
    },
    setBreadcrumbs: () => {},
    setHelpExtension: () => {},
    setBadge: () => {}
  },
  docLinks: {
    DOC_LINK_VERSION: '0',
    ELASTIC_WEBSITE_URL: 'https://www.elastic.co/',
    links: {
      apm: {},
      observability: {
        guide: ''
      }
    }
  },
  http: {
    basePath: {
      prepend: path => `/basepath${path}`,
      get: () => '/basepath'
    }
  },
  i18n: {
    Context: ({
      children
    }) => children
  },
  notifications: {
    toasts: {
      addWarning: () => {},
      addDanger: () => {},
      add: () => {}
    }
  },
  uiSettings: {
    get: key => uiSettings[key],
    get$: key => (0, _rxjs.of)(mockCore.uiSettings.get(key))
  },
  unifiedSearch: {
    autocomplete: {
      hasQuerySuggestions: () => Promise.resolve(false),
      getQuerySuggestions: () => [],
      getValueSuggestions: () => new Promise(resolve => {
        setTimeout(() => {
          resolve([]);
        }, 300);
      })
    }
  },
  data: {
    query: {
      queryString: {
        getQuery: jest.fn(),
        setQuery: jest.fn(),
        clearQuery: jest.fn()
      },
      timefilter: {
        timefilter: {
          setTime: jest.fn(),
          setRefreshInterval: jest.fn()
        }
      }
    }
  },
  dataViews: {
    create: jest.fn()
  }
};
const mockUnifiedSearchBar = {
  ui: {
    SearchBar: () => /*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 22
      }
    })
  }
};
const mockApmPluginContext = {
  core: mockCore,
  plugins: mockPlugin,
  unifiedSearch: mockUnifiedSearchBar,
  observabilityAIAssistant: {
    service: {
      setScreenContext: () => _lodash.noop
    }
  },
  share: {
    url: {
      locators: {
        get: jest.fn()
      }
    }
  }
};
function MockApmPluginStorybook({
  children,
  apmContext = {},
  routePath,
  serviceContextValue = {}
}) {
  const contextMock = (0, _lodash.merge)({}, mockApmPluginContext, apmContext);
  (0, _create_call_apm_api.createCallApmApi)(contextMock.core);
  const KibanaReactContext = (0, _public.createKibanaReactContext)(contextMock.core);
  const history = (0, _history.createMemoryHistory)({
    initialEntries: [routePath || '/services/?rangeFrom=now-15m&rangeTo=now']
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.__IntlProvider, {
    locale: "en",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_plugin_context.ApmPluginContext.Provider, {
    value: contextMock,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_service_context.APMServiceContext.Provider, {
    value: serviceContextValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _apm_route_config.apmRouter,
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_mock_time_range_metadata_context_provider.MockTimeRangeContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.ApmTimeRangeMetadataContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  }, children))))))));
}