"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceOverview = TraceOverview;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _apm_main_template = require("../../routing/templates/apm_main_template");
var _breadcrumb = require("../breadcrumb");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/trace_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TraceOverview({
  children
}) {
  const title = _i18n.i18n.translate('xpack.apm.views.traceOverview.title', {
    defaultMessage: 'Traces'
  });
  return /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    href: "/traces",
    title: title,
    omitOnServerless: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    pageTitle: title,
    pageSectionProps: {
      contentProps: {
        style: {
          display: 'flex',
          flexGrow: 1
        }
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 7
    }
  }, children));
}