"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNodeAgentInstructions = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _api_key_callout = require("./api_key_callout");
var _agent_config_instructions = require("../agent_config_instructions");
var _instruction_variants = require("../instruction_variants");
var _agent_status_instructions = require("../agent_status_instructions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/onboarding/instructions/node_agent.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createNodeAgentInstructions = commonOptions => {
  const {
    baseUrl,
    apmServerUrl,
    apiKeyDetails,
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  } = commonOptions;
  return [{
    title: _i18n.i18n.translate('xpack.apm.onboarding.node.install.title', {
      defaultMessage: 'Install the APM agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.node.install.textPre', {
      defaultMessage: 'Install the APM agent for Node.js as a dependency to your application.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      isCopyable: true,
      copyAriaLabel: _i18n.i18n.translate('xpack.apm.onboarding.node.install.copyAriaLabel', {
        defaultMessage: 'Copy the code to install the APM agent for Node.js'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 11
      }
    }, "npm install elastic-apm-node --save"))
  }, {
    title: _i18n.i18n.translate('xpack.apm.onboarding.node.configure.title', {
      defaultMessage: 'Configure the agent'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.node.configure.textPre', {
      defaultMessage: 'Agents are libraries that run inside of your application process. \
 APM services are created programmatically based on the `serviceName`. \
 This agent supports a variety of frameworks but can also be used with your custom stack.'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 11
      }
    }), ((apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout) || (apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_api_key_callout.ApiKeyCallout, {
      isError: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeyErrorCallout,
      isSuccess: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.displayApiKeySuccessCallout,
      errorMessage: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.errorMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: _instruction_variants.INSTRUCTION_VARIANT.NODE,
      apmServerUrl: apmServerUrl,
      apiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.apiKey,
      createApiKey: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createAgentKey,
      createApiKeyLoading: apiKeyDetails === null || apiKeyDetails === void 0 ? void 0 : apiKeyDetails.createApiKeyLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.onboarding.node.configure.textPost', {
      defaultMessage: 'See [the documentation]({documentationLink}) for advanced usage, including how to use with \
[Babel/ES Modules]({babelEsModulesLink}).',
      values: {
        documentationLink: `${baseUrl}guide/en/apm/agent/nodejs/current/index.html`,
        babelEsModulesLink: `${baseUrl}guide/en/apm/agent/nodejs/current/advanced-setup.html#es-modules`
      }
    })))
  }, (0, _agent_status_instructions.agentStatusCheckInstruction)({
    checkAgentStatus,
    agentStatus,
    agentStatusLoading
  })];
};
exports.createNodeAgentInstructions = createNodeAgentInstructions;