"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverviewTabs = TransactionOverviewTabs;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _url_helpers = require("../../../../shared/links/url_helpers");
var _transactions_tab = require("./transactions_tab");
var _os_version_tab = require("./os_version_tab");
var _app_version_tab = require("./app_version_tab");
var _devices_tab = require("./devices_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/transaction_overview/transaction_overview_tabs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tabs = [_transactions_tab.transactionsTab, _app_version_tab.appVersionTab, _os_version_tab.osVersionTab, _devices_tab.devicesTab];
function TransactionOverviewTabs({
  agentName,
  environment,
  start,
  end,
  kuery,
  comparisonEnabled,
  offset,
  mobileSelectedTab
}) {
  var _tabs$find;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    component: TabContent
  } = (_tabs$find = tabs.find(tab => tab.key === mobileSelectedTab)) !== null && _tabs$find !== void 0 ? _tabs$find : _transactions_tab.transactionsTab;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, tabs.map(({
    dataTestSubj,
    key,
    label
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": dataTestSubj,
    key: key,
    isSelected: key === mobileSelectedTab,
    onClick: () => {
      (0, _url_helpers.push)(history, {
        query: {
          mobileSelectedTab: key
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(TabContent, {
    agentName,
    environment,
    start,
    end,
    kuery,
    comparisonEnabled,
    offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }));
}