"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retryUntil = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RETRY_UNTIL_DEFAULT_COUNT = 20;
const RETRY_UNTIL_DEFAULT_WAIT = 100; // milliseconds

const retryUntil = async (label, fn, count = RETRY_UNTIL_DEFAULT_COUNT, wait = RETRY_UNTIL_DEFAULT_WAIT) => {
  await delay(wait);
  while (count > 0) {
    count--;
    if (await fn()) return true;

    // eslint-disable-next-line no-console
    console.log(`attempt failed waiting for "${label}", attempts left: ${count}`);
    if (count === 0) return false;
    await delay(wait);
  }
  return false;
};
exports.retryUntil = retryUntil;
const delay = async millis => await new Promise(resolve => setTimeout(resolve, millis));