"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatRule = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatRule = ({
  rule,
  ruleType
}) => {
  return {
    [_ruleDataUtils.ALERT_RULE_CATEGORY]: ruleType.name,
    [_ruleDataUtils.ALERT_RULE_CONSUMER]: rule.consumer,
    [_ruleDataUtils.ALERT_RULE_EXECUTION_UUID]: rule.executionId,
    [_ruleDataUtils.ALERT_RULE_NAME]: rule.name,
    [_ruleDataUtils.ALERT_RULE_PARAMETERS]: rule.parameters,
    [_ruleDataUtils.ALERT_RULE_PRODUCER]: ruleType.producer,
    [_ruleDataUtils.ALERT_RULE_REVISION]: rule.revision,
    [_ruleDataUtils.ALERT_RULE_TYPE_ID]: ruleType.id,
    [_ruleDataUtils.ALERT_RULE_TAGS]: rule.tags,
    [_ruleDataUtils.ALERT_RULE_UUID]: rule.id,
    [_ruleDataUtils.SPACE_IDS]: [rule.spaceId]
  };
};
exports.formatRule = formatRule;