"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsSuggestions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _no_results_suggestion_default = require("./no_results_suggestion_default");
var _no_results_suggestion_when_filters = require("./no_results_suggestion_when_filters");
var _no_results_suggestion_when_query = require("./no_results_suggestion_when_query");
var _no_results_suggestion_when_time_range = require("./no_results_suggestion_when_time_range");
var _utils = require("../../layout/utils");
var _use_discover_services = require("../../../../../hooks/use_discover_services");
var _use_fetch_occurances_range = require("./use_fetch_occurances_range");
var _no_results_illustration = require("./assets/no_results_illustration");
var _use_is_esql_mode = require("../../../hooks/use_is_esql_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/no_results/no_results_suggestions/no_results_suggestions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoResultsSuggestions = ({
  dataView,
  isTimeBased,
  query,
  filters,
  onDisableFilters
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    data,
    uiSettings,
    timefilter,
    toastNotifications
  } = services;
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const hasQuery = Boolean((0, _esQuery.isOfQueryType)(query) && query.query) || isEsqlMode;
  const hasFilters = (0, _utils.hasActiveFilter)(filters);
  const [timeRangeExtendingStatus, setTimeRangeExtendingStatus] = (0, _react.useState)(_use_fetch_occurances_range.TimeRangeExtendingStatus.initial);
  const {
    fetch
  } = (0, _use_fetch_occurances_range.useFetchOccurrencesRange)({
    dataView,
    query,
    filters,
    services: {
      data,
      uiSettings
    }
  });
  const extendTimeRange = (0, _react.useCallback)(async () => {
    setTimeRangeExtendingStatus(_use_fetch_occurances_range.TimeRangeExtendingStatus.loading);
    const {
      status,
      range
    } = await fetch();
    if (status === _use_fetch_occurances_range.TimeRangeExtendingStatus.succeedWithResults && range !== null && range !== void 0 && range.from && range !== null && range !== void 0 && range.to) {
      timefilter.setTime({
        from: range.from,
        to: range.to
      });
      return;
    }
    setTimeRangeExtendingStatus(status);
    if (status === _use_fetch_occurances_range.TimeRangeExtendingStatus.failed) {
      toastNotifications.addDanger(_i18n.i18n.translate('discover.noResults.suggestion.expandTimeRangeFailedNotification', {
        defaultMessage: 'Request failed when searching the entire time range of documents'
      }));
    } else if (status === _use_fetch_occurances_range.TimeRangeExtendingStatus.timedOut) {
      toastNotifications.addDanger(_i18n.i18n.translate('discover.noResults.suggestion.expandTimeRangeTimedOutNotification', {
        defaultMessage: 'Request timed out when searching the entire time range of documents'
      }));
    }
  }, [fetch, setTimeRangeExtendingStatus, timefilter, toastNotifications]);
  const canAdjustSearchCriteria = isTimeBased || hasFilters || hasQuery;
  const body = canAdjustSearchCriteria ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.noResults.suggestion.tryText",
    defaultMessage: "Here are some things to try:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    css: (0, _react2.css)`
          display: inline-block;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, isTimeBased && /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_time_range.NoResultsSuggestionWhenTimeRange, {
    timeRangeExtendingStatus: timeRangeExtendingStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  })), hasQuery && /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_query.NoResultsSuggestionWhenQuery, {
    querySyntax: (0, _esQuery.isOfQueryType)(query) ? query.language : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  })), hasFilters && /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_no_results_suggestion_when_filters.NoResultsSuggestionWhenFilters, {
    onDisableFilters: onDisableFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })))) : /*#__PURE__*/_react.default.createElement(_no_results_suggestion_default.NoResultsSuggestionDefault, {
    dataView: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    layout: "horizontal",
    color: "transparent",
    icon: /*#__PURE__*/_react.default.createElement(_no_results_illustration.NoResultsIllustration, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }),
    hasBorder: false,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "discoverNoResults",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noResults.searchExamples.noResultsMatchSearchCriteriaTitle",
      defaultMessage: "No results match your search\xA0criteria",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    })),
    body: body,
    actions: !isEsqlMode && isTimeBased ? /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
              min-block-size: ${euiTheme.size.xxl};
            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }, [_use_fetch_occurances_range.TimeRangeExtendingStatus.initial, _use_fetch_occurances_range.TimeRangeExtendingStatus.loading, _use_fetch_occurances_range.TimeRangeExtendingStatus.timedOut, _use_fetch_occurances_range.TimeRangeExtendingStatus.failed].includes(timeRangeExtendingStatus) && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: extendTimeRange,
      disabled: timeRangeExtendingStatus === _use_fetch_occurances_range.TimeRangeExtendingStatus.loading,
      isLoading: timeRangeExtendingStatus === _use_fetch_occurances_range.TimeRangeExtendingStatus.loading,
      "data-test-subj": "discoverNoResultsViewAllMatches",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noResults.suggestion.searchAllMatchesButtonText",
      defaultMessage: "Search entire time range",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 17
      }
    }))) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  });
};
exports.NoResultsSuggestions = NoResultsSuggestions;