"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Settings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _json_editor = require("./json_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Settings = ({
  settings,
  setSettings,
  readonly = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [localSettings, setLocalSettings] = (0, _react.useState)(JSON.stringify(settings, null, 2));
  const [showSettings, setShowSettings] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setLocalSettings(JSON.stringify(settings, null, 2));
  }, [settings]);
  (0, _useDebounce.default)(() => {
    if (setSettings) {
      setSettings(localSettings);
    }
  }, 100, [localSettings]);
  const css = (0, _react.useMemo)(() => readonly ? {} : {
    backgroundColor: euiTheme.colors.backgroundBaseSubdued
  }, [euiTheme, readonly]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: 'containsTimeField',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.customizeIndexSettingsLabel",
      defaultMessage: "Customize index settings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }),
    checked: showSettings,
    onChange: e => setShowSettings(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), showSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "none",
    "data-test-subj": "dvSettingsEditor",
    css: css,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: _json_editor.EDITOR_MODE.JSON,
    readOnly: readonly,
    value: localSettings,
    onChange: value => {
      setLocalSettings(value);
    },
    transparentBackground: readonly === false,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  })) : null);
};
exports.Settings = Settings;