"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImagePreviewModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/image_preview_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * By default the image formatter sets the max-width to "none" on the <img /> tag
 * To render nicely the image in the modal we want max_width: 100%
 */
const setMaxWidthImage = imgHTML => {
  const regex = new RegExp('max-width:[^;]+;', 'gm');
  if (regex.test(imgHTML)) {
    return imgHTML.replace(regex, 'max-width: 100%;');
  }
  return imgHTML;
};
const ImagePreviewModal = ({
  imgHTML,
  closeModal
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.previewImageModal
    // We  can dangerously set HTML here because this content is guaranteed to have been run through a valid field formatter first.
    ,
    dangerouslySetInnerHTML: {
      __html: setMaxWidthImage(imgHTML)
    } // eslint-disable-line react/no-danger
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })));
};
exports.ImagePreviewModal = ImagePreviewModal;
const componentStyles = {
  previewImageModal: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.base,
    '& img': {
      maxWidth: '100%'
    }
  })
};