"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardViewport = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _controlsConstants = require("@kbn/controls-constants");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _control_group_manager = require("../../dashboard_api/control_group_manager");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _use_dashboard_internal_api = require("../../dashboard_api/use_dashboard_internal_api");
var _grid = require("../grid");
var _dashboard_empty_screen = require("./empty_screen/dashboard_empty_screen");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/viewport/dashboard_viewport.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardViewport = () => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const dashboardInternalApi = (0, _use_dashboard_internal_api.useDashboardInternalApi)();
  const [hasControls, setHasControls] = (0, _react.useState)(false);
  const [controlGroupApi, dashboardTitle, description, expandedPanelId, layout, viewMode, useMargins, fullScreenMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.controlGroupApi$, dashboardApi.title$, dashboardApi.description$, dashboardApi.expandedPanelId$, dashboardInternalApi.layout$, dashboardApi.viewMode$, dashboardApi.settings.useMargins$, dashboardApi.fullScreenMode$);
  const onExit = (0, _react.useCallback)(() => {
    dashboardApi.setFullScreenMode(false);
  }, [dashboardApi]);
  const {
    panelCount,
    visiblePanelCount,
    sectionCount
  } = (0, _react.useMemo)(() => {
    const panels = Object.values(layout.panels);
    const visiblePanels = panels.filter(({
      grid
    }) => {
      return !dashboardInternalApi.isSectionCollapsed(grid.sectionId);
    });
    return {
      panelCount: panels.length,
      visiblePanelCount: visiblePanels.length,
      sectionCount: Object.keys(layout.sections).length
    };
  }, [layout, dashboardInternalApi]);
  const classes = (0, _classnames.default)('dshDashboardViewport', {
    'dshDashboardViewport--empty': panelCount === 0 && sectionCount === 0,
    'dshDashboardViewport--print': viewMode === 'print',
    'dshDashboardViewport--panelExpanded': Boolean(expandedPanelId)
  });
  (0, _react.useEffect)(() => {
    if (!controlGroupApi) {
      return;
    }
    const subscription = controlGroupApi.children$.subscribe(children => {
      setHasControls(Object.keys(children).length > 0);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroupApi]);
  const [controlsReady, setControlsReady] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let ignore = false;
    dashboardInternalApi.untilControlsInitialized().then(() => {
      if (!ignore) {
        setControlsReady(true);
      }
    });
    return () => {
      ignore = true;
    };
  }, [dashboardInternalApi]);
  const styles = (0, _use_memo_css.useMemoCss)(dashboardViewportStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('dshDashboardViewportWrapper', {
      'dshDashboardViewportWrapper--defaultBg': !useMargins,
      'dshDashboardViewportWrapper--isFullscreen': fullScreenMode
    }),
    css: styles.wrapper,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, viewMode !== 'print' ? /*#__PURE__*/_react.default.createElement("div", {
    className: hasControls ? 'dshDashboardViewport-controls' : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
    key: dashboardApi.uuid,
    hidePanelChrome: true,
    panelProps: {
      hideLoader: true
    },
    type: _controlsConstants.CONTROLS_GROUP_TYPE,
    maybeId: _control_group_manager.CONTROL_GROUP_EMBEDDABLE_ID,
    getParentApi: () => {
      return {
        ...dashboardApi,
        reload$: dashboardInternalApi.controlGroupReload$
      };
    },
    onApiAvailable: api => dashboardInternalApi.setControlGroupApi(api),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  })) : null, fullScreenMode && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButton, {
    onExit: onExit,
    toggleChrome: !dashboardApi.isEmbeddedExternally,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: classes,
    css: styles.viewport,
    "data-shared-items-container": true,
    "data-title": dashboardTitle,
    "data-description": description,
    "data-shared-items-count": visiblePanelCount,
    "data-test-subj": 'dshDashboardViewport',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, panelCount === 0 && sectionCount === 0 ? /*#__PURE__*/_react.default.createElement(_dashboard_empty_screen.DashboardEmptyScreen, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }) : viewMode === 'print' || controlsReady ? /*#__PURE__*/_react.default.createElement(_grid.DashboardGrid, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }) : null));
};
exports.DashboardViewport = DashboardViewport;
const dashboardViewportStyles = {
  wrapper: ({
    euiTheme
  }) => ({
    flex: 'auto',
    display: 'flex',
    flexDirection: 'column',
    width: '100%',
    '&.dshDashboardViewportWrapper--defaultBg': {
      backgroundColor: euiTheme.colors.emptyShade
    },
    '.dshDashboardViewport-controls': {
      margin: `0 ${euiTheme.size.s}`,
      paddingTop: euiTheme.size.s
    }
  }),
  viewport: {
    width: '100%',
    '&.dshDashboardViewport--empty': {
      height: '100%'
    },
    '&.dshDashboardViewport--panelExpanded': {
      flex: 1
    },
    '&.dshDashboardViewport--print': {
      '.kbnGrid': {
        display: 'block !important'
      },
      '.kbnGridSectionHeader, .kbnGridSectionFooter': {
        display: 'none'
      },
      '.kbnGridPanel': {
        height: '100% !important'
      }
    }
  }
};