"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSaveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _kibana_services = require("../../services/kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_api/save_modal/save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardSaveModal = ({
  customModalTitle,
  description,
  onClose,
  onSave,
  showCopyOnSave,
  showStoreTimeOnSave = true,
  tags,
  title,
  timeRestore
}) => {
  const [selectedTags, setSelectedTags] = _react.default.useState(tags !== null && tags !== void 0 ? tags : []);
  const [persistSelectedTimeInterval, setPersistSelectedTimeInterval] = _react.default.useState(timeRestore);
  const saveDashboard = _react.default.useCallback(async ({
    newTitle,
    newDescription,
    newCopyOnSave,
    isTitleDuplicateConfirmed,
    onTitleDuplicate
  }) => onSave({
    newTitle,
    newDescription,
    newCopyOnSave,
    newTimeRestore: persistSelectedTimeInterval,
    isTitleDuplicateConfirmed,
    onTitleDuplicate,
    newTags: selectedTags
  }), [onSave, persistSelectedTimeInterval, selectedTags]);
  const renderDashboardSaveOptions = (0, _react.useCallback)(() => {
    const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
    const tagSelector = savedObjectsTaggingApi ? /*#__PURE__*/_react.default.createElement(savedObjectsTaggingApi.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: selectedTags,
      onTagsSelected: selectedTagIds => {
        setSelectedTags(selectedTagIds);
      },
      markOptional: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, tagSelector, showStoreTimeOnSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "storeTimeWithDashboard",
      checked: persistSelectedTimeInterval,
      onChange: event => {
        setPersistSelectedTimeInterval(event.target.checked);
      },
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowLabel",
        defaultMessage: "Store time with dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 21
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowHelpText",
        defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 21
        }
      }),
      position: "top",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 17
      }
    })))) : null);
  }, [persistSelectedTimeInterval, selectedTags, showStoreTimeOnSave]);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModalWithSaveResult, {
    onSave: saveDashboard,
    onClose: onClose,
    title: title,
    description: description,
    showDescription: true,
    showCopyOnSave: showCopyOnSave,
    initialCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('dashboard.topNav.saveModal.objectType', {
      defaultMessage: 'dashboard'
    }),
    customModalTitle: customModalTitle,
    options: renderDashboardSaveOptions(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  });
};
exports.DashboardSaveModal = DashboardSaveModal;