"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternDeleteProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _actions = require("../store/actions");
var _utils = require("../../../common/services/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/auto_follow_pattern_delete_provider.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AutoFollowPatternDeleteProviderUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false,
      ids: null
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "deleteAutoFollowPattern", id => {
      this.setState({
        isModalOpen: true,
        ids: (0, _utils.arrify)(id)
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      this.props.deleteAutoFollowPattern(this.state.ids);
      this.setState({
        isModalOpen: false,
        ids: null
      });
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderModal", () => {
      const {
        ids
      } = this.state;
      const isSingle = ids.length === 1;
      const title = isSingle ? _i18n.i18n.translate('xpack.crossClusterReplication.deleteAutoFollowPattern.confirmModal.deleteSingleTitle', {
        defaultMessage: `Remove auto-follow pattern ''{name}''?`,
        values: {
          name: ids[0]
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.deleteAutoFollowPattern.confirmModal.deleteMultipleTitle', {
        defaultMessage: `Remove {count} auto-follow patterns?`,
        values: {
          count: ids.length
        }
      });
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        _react.default.createElement(_eui.EuiConfirmModal, {
          "aria-labelledby": confirmModalTitleId,
          title: title,
          titleProps: {
            id: confirmModalTitleId
          },
          onCancel: this.closeConfirmModal,
          onConfirm: this.onConfirm,
          cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.deleteAutoFollowPattern.confirmModal.cancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          buttonColor: "danger",
          confirmButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.deleteAutoFollowPattern.confirmModal.confirmButtonText', {
            defaultMessage: 'Remove'
          }),
          onMouseOver: this.onMouseOverModal,
          "data-test-subj": "deleteAutoFollowPatternConfirmation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 7
          }
        }, !isSingle && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.deleteAutoFollowPattern.confirmModal.multipleDeletionDescription",
          defaultMessage: "You are about to remove these auto-follow patterns:",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement("ul", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 13
          }
        }, ids.map(id => /*#__PURE__*/_react.default.createElement("li", {
          key: id,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 17
          }
        }, id)))))
      );
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    }, children(this.deleteAutoFollowPattern), isModalOpen && this.renderModal());
  }
}
const mapDispatchToProps = dispatch => ({
  deleteAutoFollowPattern: id => dispatch((0, _actions.deleteAutoFollowPattern)(id))
});
const AutoFollowPatternDeleteProvider = exports.AutoFollowPatternDeleteProvider = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(AutoFollowPatternDeleteProviderUi);