"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsAnyPopoverOpenNow = exports.SideNavPopover = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _use_layout_width = require("../../hooks/use_layout_width");
var _focus_adjacent_trigger = require("../../utils/focus_adjacent_trigger");
var _focus_first_element = require("../../utils/focus_first_element");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _use_hover_timeout = require("../../hooks/use_hover_timeout");
var _use_scroll = require("../../hooks/use_scroll");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/popover/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Flag for tracking if any popover is open.
 */
let anyPopoverOpen = false;

/**
 * Utility function to check if any popover is open.
 *
 * @returns true if any popover is open
 */
const getIsAnyPopoverOpenNow = () => anyPopoverOpen;
exports.getIsAnyPopoverOpenNow = getIsAnyPopoverOpenNow;
const SideNavPopover = ({
  children,
  container,
  hasContent,
  isSidePanelOpen,
  label,
  persistent = false,
  trigger
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    setTimeout,
    clearTimeout
  } = (0, _use_hover_timeout.useHoverTimeout)();
  const popoverRef = (0, _react2.useRef)(null);
  const triggerRef = (0, _react2.useRef)(null);
  const [isOpenedByClick, setIsOpenedByClick] = (0, _react2.useState)(false);
  const [isOpen, setIsOpen] = (0, _react2.useState)(false);
  const [shouldFocusOnOpen, setShouldFocusOnOpen] = (0, _react2.useState)(false);
  const setOpenedByClick = (0, _react2.useCallback)(() => setIsOpenedByClick(true), []);
  const clearOpenedByClick = (0, _react2.useCallback)(() => setIsOpenedByClick(false), []);
  const open = (0, _react2.useCallback)(() => {
    setIsOpen(true);
    anyPopoverOpen = true;
  }, []);
  const close = (0, _react2.useCallback)(() => {
    setIsOpen(false);
    clearOpenedByClick();
    clearTimeout();
    setShouldFocusOnOpen(false);
    anyPopoverOpen = false;
  }, [clearOpenedByClick, clearTimeout]);
  const handleClose = (0, _react2.useCallback)(() => {
    clearTimeout();
    close();
  }, [clearTimeout, close]);
  const tryOpen = (0, _react2.useCallback)(() => {
    if (!isSidePanelOpen && !getIsAnyPopoverOpenNow()) {
      open();
    }
  }, [isSidePanelOpen, open]);
  const handleMouseEnter = (0, _react2.useCallback)(() => {
    if (!persistent || !isOpenedByClick) {
      clearTimeout();
      if (getIsAnyPopoverOpenNow()) {
        setTimeout(tryOpen, _constants.POPOVER_HOVER_DELAY);
      } else if (!isSidePanelOpen) {
        setTimeout(open, _constants.POPOVER_HOVER_DELAY);
      }
    }
  }, [persistent, isOpenedByClick, isSidePanelOpen, clearTimeout, open, setTimeout, tryOpen]);
  const handleMouseLeave = (0, _react2.useCallback)(() => {
    if (!persistent || !isOpenedByClick) {
      setTimeout(handleClose, _constants.POPOVER_HOVER_DELAY);
    }
  }, [persistent, isOpenedByClick, setTimeout, handleClose]);
  const scrollStyles = (0, _use_scroll.useScroll)(true);
  const handleTriggerClick = (0, _react2.useCallback)(() => {
    if (persistent) {
      if (isOpen && isOpenedByClick) {
        handleClose();
      } else {
        clearTimeout();
        open();
        setOpenedByClick();
      }
    }
  }, [persistent, isOpen, isOpenedByClick, handleClose, clearTimeout, open, setOpenedByClick]);
  const handleTriggerKeyDown = (0, _react2.useCallback)(e => {
    if (e.key === 'Enter' || e.key === ' ') {
      var _trigger$props$onKeyD, _trigger$props;
      (_trigger$props$onKeyD = (_trigger$props = trigger.props).onKeyDown) === null || _trigger$props$onKeyD === void 0 ? void 0 : _trigger$props$onKeyD.call(_trigger$props, e);
      if (hasContent) {
        // Required for entering the popover with Enter or Space key
        // Otherwise the navigation happens immediately
        e.preventDefault();
        setShouldFocusOnOpen(true);
        open();
      }
    } else {
      var _trigger$props$onKeyD2, _trigger$props2;
      (_trigger$props$onKeyD2 = (_trigger$props2 = trigger.props).onKeyDown) === null || _trigger$props$onKeyD2 === void 0 ? void 0 : _trigger$props$onKeyD2.call(_trigger$props2, e);
    }
  }, [trigger, hasContent, open]);
  const handlePopoverKeyDown = (0, _react2.useCallback)(e => {
    if (e.key === 'Escape') {
      var _triggerRef$current;
      handleClose();
      (_triggerRef$current = triggerRef.current) === null || _triggerRef$current === void 0 ? void 0 : _triggerRef$current.focus();
      return;
    }
    if (e.key === 'Tab') {
      e.preventDefault();
      handleClose();
      (0, _focus_adjacent_trigger.focusAdjacentTrigger)(triggerRef, e.shiftKey ? -1 : 1);
      return;
    }
    (0, _handle_roving_index.handleRovingIndex)(e);
  }, [handleClose]);
  const handleBlur = (0, _react2.useCallback)(e => {
    var _triggerRef$current2, _popoverRef$current;
    clearTimeout();
    const nextFocused = e.relatedTarget;
    const isStayingInComponent = nextFocused && Boolean(((_triggerRef$current2 = triggerRef.current) === null || _triggerRef$current2 === void 0 ? void 0 : _triggerRef$current2.contains(nextFocused)) || ((_popoverRef$current = popoverRef.current) === null || _popoverRef$current === void 0 ? void 0 : _popoverRef$current.contains(nextFocused)));
    const isTrappedByFlyout = nextFocused === null || nextFocused === void 0 ? void 0 : nextFocused.classList.contains('euiFlyout');
    const isTrappedByPageOverlay = !!(nextFocused !== null && nextFocused !== void 0 && nextFocused.closest('.securitySolution-pageOverlay'));
    if (isStayingInComponent === false && isTrappedByFlyout === false && isTrappedByPageOverlay === false) {
      handleClose();
    }
  }, [clearTimeout, handleClose]);

  // Clean up on unmount
  (0, _react2.useEffect)(() => {
    return () => {
      clearTimeout();
      handleClose();
    };
  }, [clearTimeout, handleClose]);
  const enhancedTrigger = (0, _react2.useMemo)(() => /*#__PURE__*/(0, _react2.cloneElement)(trigger, {
    ref: triggerRef,
    'aria-haspopup': hasContent,
    'aria-expanded': hasContent ? isOpen : undefined,
    onClick: e => {
      var _trigger$props$onClic, _trigger$props3;
      (_trigger$props$onClic = (_trigger$props3 = trigger.props).onClick) === null || _trigger$props$onClic === void 0 ? void 0 : _trigger$props$onClic.call(_trigger$props3, e);
      handleTriggerClick();
    },
    onKeyDown: handleTriggerKeyDown
  }), [trigger, hasContent, isOpen, handleTriggerKeyDown, handleTriggerClick]);
  const wrapperStyles = (0, _react.css)`
    width: 100%;
  `;
  const popoverContentStyles = (0, _react.css)`
    --popover-max-height: 37.5rem;
    width: ${_use_layout_width.SIDE_PANEL_WIDTH}px;
    max-height: var(--popover-max-height);
    ${scrollStyles};
  `;
  const maskStyles = (0, _react.css)`
    position: fixed;
    inset: 0;
    z-index: calc(${euiTheme.levels.menu} - 1);
  `;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: wrapperStyles,
    onMouseEnter: handleMouseEnter,
    onMouseLeave: handleMouseLeave,
    onFocus: handleMouseEnter,
    onBlur: handleBlur,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    "aria-label": label,
    anchorPosition: "rightUp",
    buffer: [_constants.TOP_BAR_HEIGHT + _constants.TOP_BAR_POPOVER_GAP, 0, _constants.BOTTOM_POPOVER_GAP, _constants.POPOVER_OFFSET],
    button: enhancedTrigger,
    closePopover: handleClose,
    container: container,
    display: "block",
    hasArrow: false,
    isOpen: hasContent && !isSidePanelOpen && isOpen,
    offset: _constants.POPOVER_OFFSET,
    ownFocus: false,
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    ref: ref => {
      popoverRef.current = ref;
      if (ref) {
        const elements = (0, _get_focusable_elements.getFocusableElements)(ref);
        (0, _update_tab_indices.updateTabIndices)(elements);
        if (shouldFocusOnOpen) {
          (0, _focus_first_element.focusFirstElement)(popoverRef);
          setShouldFocusOnOpen(false);
        }
      }
    },
    onKeyDown: handlePopoverKeyDown,
    css: popoverContentStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }, typeof children === 'function' ? children(handleClose) : children)), persistent && isOpenedByClick && isOpen &&
  /*#__PURE__*/
  // The persistent popover does not affect keyboard navigation users
  // eslint-disable-next-line jsx-a11y/click-events-have-key-events
  _react2.default.createElement("div", {
    onClick: handleClose,
    css: maskStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }));
};
exports.SideNavPopover = SideNavPopover;