"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverInvalidSelections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_invalid_selections.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const optionsListPopoverInvalidSelectionsStyles = {
  title: ({
    euiTheme
  }) => (0, _react2.css)({
    paddingLeft: euiTheme.size.m
  })
};
const OptionsListPopoverInvalidSelections = () => {
  var _componentApi$default;
  const {
    componentApi
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const styles = (0, _use_memo_css.useMemoCss)(optionsListPopoverInvalidSelectionsStyles);
  const [invalidSelections, fieldFormatter] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.invalidSelections$, componentApi.fieldFormatter);
  const defaultPanelTitle = (0, _presentationPublishing.useStateFromPublishingSubject)((_componentApi$default = componentApi.defaultTitle$) !== null && _componentApi$default !== void 0 ? _componentApi$default : new _rxjs.BehaviorSubject(undefined));
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)([]); // will be set in following useEffect
  (0, _react.useEffect)(() => {
    /* This useEffect makes selectableOptions responsive to unchecking options */
    const options = Array.from(invalidSelections).map(key => {
      return {
        key: String(key),
        label: fieldFormatter(key),
        checked: 'on',
        css: (0, _react2.css)`
          .euiSelectableListItem__prepend {
            margin-inline-end: 0;
          }
        `,
        className: 'optionsList__selectionInvalid',
        'data-test-subj': `optionsList-control-invalid-selection-${key}`,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 13
          }
        }, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionScreenReaderText(), '" "', " "))
      };
    });
    setSelectableOptions(options);
  }, [fieldFormatter, invalidSelections]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "optionList__invalidSelectionLabel",
    css: styles.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    title: _options_list_strings.OptionsListStrings.popover.getInvalidSelectionScreenReaderText(),
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionTitle(invalidSelections.size))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionAriaLabel(defaultPanelTitle !== null && defaultPanelTitle !== void 0 ? defaultPanelTitle : '', invalidSelections.size),
    options: selectableOptions,
    listProps: {
      onFocusBadge: false
    },
    onChange: (newSuggestions, _, changedOption) => {
      setSelectableOptions(newSuggestions);
      componentApi.deselectOption(changedOption.key);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, list => list));
};
exports.OptionsListPopoverInvalidSelections = OptionsListPopoverInvalidSelections;