"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntersectionType = void 0;
var _object_type = require("./object_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class IntersectionType extends _object_type.ObjectType {
  constructor(types, options) {
    const props = types.reduce((mergedProps, type) => {
      Object.entries(type.getPropSchemas()).forEach(([key, value]) => {
        if (mergedProps[key] !== undefined) {
          throw new Error(`Duplicate key found in intersection: '${key}'`);
        }
        mergedProps[key] = value;
      });
      return mergedProps;
    }, {});
    super(props, options);
  }
}
exports.IntersectionType = IntersectionType;