"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Gradient = Gradient;
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _reactRedux = require("react-redux");
var _color_math = require("../../color/color_math");
var _color_handling = require("../../color/color_handling");
var _gradient_add_stop = require("./gradient_add_stop");
var _color_swatch = require("../color_picker/color_swatch");
var _color_mapping = require("../../state/color_mapping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/palette_selector/gradient.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function Gradient({
  paletteId,
  colorMode,
  isDarkMode,
  palettes
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  if (colorMode.type === 'categorical') {
    return null;
  }
  const currentPalette = palettes.get(paletteId);
  const gradientColorScale = (0, _color_handling.getGradientColorScale)(colorMode, palettes, isDarkMode);
  const startStepColor = colorMode.sort === 'asc' ? colorMode.steps.length === 1 ? undefined : colorMode.steps.at(-1) : colorMode.steps.at(0);
  const startStepIndex = colorMode.sort === 'asc' ? colorMode.steps.length === 1 ? NaN : colorMode.steps.length - 1 : 0;
  const endStepColor = colorMode.sort === 'asc' ? colorMode.steps.at(0) : colorMode.steps.length === 1 ? undefined : colorMode.steps.at(-1);
  const endStepIndex = colorMode.sort === 'asc' ? 0 : colorMode.steps.length === 1 ? NaN : colorMode.steps.length - 1;
  const middleStepColor = colorMode.steps.length === 3 ? colorMode.steps[1] : undefined;
  const middleStepIndex = colorMode.steps.length === 3 ? 1 : NaN;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: relative;
        height: 24px;
        &:hover {
          button {
            opacity: 1;
          }
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: absolute;
          left: 6px;
          right: 6px;
          height: 8px;
          top: 12px;
          border-radius: 6px;
          background-origin: border-box;
          background-image: linear-gradient(
            to right,
            ${[gradientColorScale(0), gradientColorScale(0.5), gradientColorScale(1)].join(',')}
          );
          border: 1px solid ${(0, _color_math.changeAlpha)(_uiTheme.euiThemeVars.euiColorDarkestShade, 0.2)};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: absolute;
          left: 0;
          top: 8px;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, startStepColor ? /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "gradient",
    colorMode: colorMode,
    assignmentColor: startStepColor,
    palettes: palettes,
    index: startStepIndex,
    palette: currentPalette,
    total: colorMode.steps.length,
    swatchShape: "round",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateGradientColorStep)({
        index: startStepIndex,
        color
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_gradient_add_stop.AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: absolute;
          width: 16px;
          height: 16px;
          left: 50%;
          top: 8px;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, middleStepColor ? /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "gradient",
    colorMode: colorMode,
    assignmentColor: middleStepColor,
    palettes: palettes,
    index: middleStepIndex,
    palette: currentPalette,
    total: colorMode.steps.length,
    swatchShape: "round",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateGradientColorStep)({
        index: middleStepIndex,
        color
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }) : colorMode.steps.length === 2 ? /*#__PURE__*/_react.default.createElement(_gradient_add_stop.AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }) : undefined), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: absolute;
          width: 16px;
          height: 16px;
          top: 8px;
          right: 0;
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, endStepColor ? /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "gradient",
    colorMode: colorMode,
    assignmentColor: endStepColor,
    palettes: palettes,
    index: endStepIndex,
    palette: currentPalette,
    total: colorMode.steps.length,
    swatchShape: "round",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateGradientColorStep)({
        index: endStepIndex,
        color
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_gradient_add_stop.AddStop, {
    colorMode: colorMode,
    currentPalette: currentPalette,
    at: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  })));
}