"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldAddComma = exports.shouldAddAnd = exports.createAssigneesUserActionBuilder = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _domain = require("../../../common/types/domain");
var _display_name = require("../user_profiles/display_name");
var _user_tooltip = require("../user_profiles/user_tooltip");
var _common = require("./common");
var i18n = _interopRequireWildcard(require("./translations"));
var _data_test_subject = require("../user_profiles/data_test_subject");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/assignees.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormatListItem = ({
  children,
  index,
  listSize
}) => {
  if (shouldAddAnd(index, listSize)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.AND, " ", children);
  } else if (shouldAddComma(index, listSize)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, ',');
  }
  return children;
};
FormatListItem.displayName = 'FormatListItem';
const shouldAddComma = (index, arrayLength) => {
  return arrayLength > 2 && index !== arrayLength - 1;
};
exports.shouldAddComma = shouldAddComma;
const shouldAddAnd = (index, arrayLength) => {
  return arrayLength > 1 && index === arrayLength - 1;
};
exports.shouldAddAnd = shouldAddAnd;
const Themselves = ({
  index,
  numOfAssigness
}) => /*#__PURE__*/_react.default.createElement(FormatListItem, {
  index: index,
  listSize: numOfAssigness,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.THEMSELVES));
Themselves.displayName = 'Themselves';
const AssigneeComponent = ({
  assignee,
  index,
  numOfAssigness
}) => {
  var _assignee$profile;
  return /*#__PURE__*/_react.default.createElement(FormatListItem, {
    index: index,
    listSize: numOfAssigness,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 3
    }
  }, /*#__PURE__*/_react.default.createElement(_user_tooltip.UserToolTip, {
    userInfo: assignee.profile,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, (0, _display_name.getName)((_assignee$profile = assignee.profile) === null || _assignee$profile === void 0 ? void 0 : _assignee$profile.user))));
};
AssigneeComponent.displayName = 'Assignee';
const AssigneesComponent = ({
  assignees,
  createdByUser
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, assignees.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "xs",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 7
  }
}, assignees.map((assignee, index) => {
  const usernameDataTestSubj = (0, _data_test_subject.getUsernameDataTestSubj)(assignee);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": `ua-assignee-${usernameDataTestSubj}`,
    grow: false,
    key: assignee.uid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, doesAssigneeMatchCreatedByUser(assignee, createdByUser) ? /*#__PURE__*/_react.default.createElement(Themselves, {
    index: index,
    numOfAssigness: assignees.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(AssigneeComponent, {
    assignee: assignee,
    index: index,
    numOfAssigness: assignees.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 19
    }
  })));
})));
AssigneesComponent.displayName = 'Assignees';
const Assignees = /*#__PURE__*/(0, _react.memo)(AssigneesComponent);
const doesAssigneeMatchCreatedByUser = (assignee, createdByUser) => {
  var _assignee$profile2;
  return assignee.uid === (createdByUser === null || createdByUser === void 0 ? void 0 : createdByUser.profileUid) ||
  // cases created before the assignees functionality will not have the profileUid so we'll need to fallback to the
  // next best field
  (assignee === null || assignee === void 0 ? void 0 : (_assignee$profile2 = assignee.profile) === null || _assignee$profile2 === void 0 ? void 0 : _assignee$profile2.user.username) === createdByUser.username;
};
const getLabelTitle = (userAction, userProfiles) => {
  const assignees = userAction.payload.assignees.map(assignee => {
    const profile = userProfiles === null || userProfiles === void 0 ? void 0 : userProfiles.get(assignee.uid);
    return {
      uid: assignee.uid,
      profile
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "xs",
    component: "span",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "ua-assignees-label",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, userAction.action === _domain.UserActionActions.add && i18n.ASSIGNED, userAction.action === _domain.UserActionActions.delete && i18n.UNASSIGNED), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Assignees, {
    createdByUser: userAction.createdBy,
    assignees: assignees,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })));
};
const createAssigneesUserActionBuilder = ({
  userAction,
  handleOutlineComment,
  userProfiles
}) => ({
  build: () => {
    const assigneesUserAction = userAction;
    const label = getLabelTitle(assigneesUserAction, userProfiles);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'userAvatar'
    });
    return commonBuilder.build();
  }
});
exports.createAssigneesUserActionBuilder = createAssigneesUserActionBuilder;