"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddObservable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_cases_context = require("../cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_post_observables = require("../../containers/use_post_observables");
var _observable_form = require("./observable_form");
var _use_cases_features = require("../../common/use_cases_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/observables/add_observable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddObservableComponent = ({
  caseData
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    isLoading,
    mutateAsync: postObservable
  } = (0, _use_post_observables.usePostObservable)(caseData.id);
  const {
    observablesAuthorized: isObservablesEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const closeModal = () => setIsModalVisible(false);
  const showModal = () => setIsModalVisible(true);
  const handleCreateObservable = (0, _react.useCallback)(async observable => {
    await postObservable({
      observable
    });
    closeModal();
  }, [postObservable]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return permissions.create && permissions.update ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !isObservablesEnabled,
    title: isObservablesEnabled ? undefined : i18n.PLATINUM_NOTICE,
    "data-test-subj": "cases-observables-add",
    iconType: "plusInCircle",
    onClick: showModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, i18n.ADD_OBSERVABLE), isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "cases-observables-add-modal",
    onClose: closeModal,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, i18n.ADD_OBSERVABLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_observable_form.ObservableForm, {
    isLoading: isLoading,
    onSubmit: handleCreateObservable,
    onCancel: closeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  })))) : null;
};
AddObservableComponent.displayName = 'AddObservable';
const AddObservable = exports.AddObservable = /*#__PURE__*/_react.default.memo(AddObservableComponent);