"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditableMarkdown = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _ = require(".");
var _utils = require("../utils");
var _utils2 = require("./utils");
var _editable_markdown_footer = require("./editable_markdown_footer");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/editable_markdown_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditableMarkDownRenderer = /*#__PURE__*/(0, _react.forwardRef)(({
  id,
  content,
  caseId,
  fieldName,
  onChangeEditable,
  onSaveContent,
  editorRef,
  formSchema
}, ref) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const draftStorageKey = (0, _utils2.getMarkdownEditorStorageKey)({
    appId: owner[0],
    caseId,
    commentId: id
  });
  const initialState = {
    content
  };
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema: formSchema
  });
  const {
    submit,
    setFieldValue,
    isValid: isFormValid
  } = form;
  const setComment = (0, _react.useCallback)(newComment => {
    setFieldValue(fieldName, newComment);
  }, [setFieldValue, fieldName]);
  (0, _react.useImperativeHandle)(ref, () => ({
    setComment,
    editor: editorRef.current
  }));
  const handleCancelAction = (0, _react.useCallback)(() => {
    onChangeEditable(id);
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  }, [id, onChangeEditable, draftStorageKey]);
  const handleSaveAction = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid && data.content !== content) {
      onSaveContent(data.content);
    }
    onChangeEditable(id);
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  }, [content, id, onChangeEditable, onSaveContent, submit, draftStorageKey]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    "data-test-subj": "editable-markdown-form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: fieldName,
    component: _.MarkdownEditorForm,
    componentProps: {
      ref: editorRef,
      'aria-label': 'Cases markdown editor',
      value: content,
      id,
      caseId,
      draftStorageKey,
      bottomRightContent: /*#__PURE__*/_react.default.createElement(_editable_markdown_footer.EditableMarkdownFooter, {
        handleSaveAction: handleSaveAction,
        handleCancelAction: handleCancelAction,
        isSaveDisabled: isFormValid !== undefined && !isFormValid,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 15
        }
      }),
      initialValue: content
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }));
});
EditableMarkDownRenderer.displayName = 'EditableMarkDownRenderer';
const EditableMarkdown = exports.EditableMarkdown = /*#__PURE__*/_react.default.memo(EditableMarkDownRenderer);