"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_files_table_columns = require("./use_files_table_columns");
var _file_preview = require("./file_preview");
var _add_file = require("./add_file");
var _use_file_preview = require("./use_file_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/files_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmptyFilesTable = ({
  caseId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 12
    }
  }, i18n.NO_FILES),
  "data-test-subj": "cases-files-table-empty",
  titleSize: "xs",
  actions: /*#__PURE__*/_react.default.createElement(_add_file.AddFile, {
    caseId: caseId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 14
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 3
  }
});
EmptyFilesTable.displayName = 'EmptyFilesTable';
const FilesTable = ({
  caseId,
  items,
  pagination,
  onChange,
  isLoading
}) => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  const [selectedFile, setSelectedFile] = (0, _react.useState)();
  const displayPreview = file => {
    setSelectedFile(file);
    showPreview();
  };
  const filesTableRowProps = (0, _react.useCallback)(file => ({
    'data-test-subj': `cases-files-table-row-${file.id}`
  }), []);
  const columns = (0, _use_files_table_columns.useFilesTableColumns)({
    caseId,
    showPreview: displayPreview
  });
  return isLoading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "cases-files-table-loading",
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, pagination.totalItemCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "cases-files-table-results-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, i18n.SHOWING_FILES(items.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: i18n.FILES_TABLE,
    items: items,
    rowHeader: "name",
    columns: columns,
    pagination: pagination,
    onChange: onChange,
    "data-test-subj": "cases-files-table",
    noItemsMessage: /*#__PURE__*/_react.default.createElement(EmptyFilesTable, {
      caseId: caseId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 25
      }
    }),
    rowProps: filesTableRowProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), isPreviewVisible && selectedFile !== undefined && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: selectedFile,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }));
};
exports.FilesTable = FilesTable;
FilesTable.displayName = 'FilesTable';