"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourceWrapper = exports.Datasource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _reactDom = require("react-dom");
var _base_form = require("./base_form");
var _lib = require("../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/datasource.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultTemplate = domNode => /*#__PURE__*/(0, _reactDom.createPortal)(/*#__PURE__*/_react.default.createElement("div", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 7
  }
}, "This datasource has no interface. Use the expression editor to make changes.")), domNode);
const DatasourceWrapperComponent = props => {
  const domNodeRef = (0, _react.useRef)(null);
  const datasourceRef = (0, _react.useRef)();
  const [argument, setArgument] = (0, _react.useState)();
  const {
    spec,
    datasourceProps,
    handlers
  } = props;
  const prevSpec = (0, _usePrevious.default)(spec);
  const onMount = (0, _react.useCallback)(ref => {
    datasourceRef.current = ref !== null && ref !== void 0 ? ref : undefined;
  }, []);
  const callRenderFn = (0, _react.useCallback)(domNode => {
    const {
      template
    } = spec;
    if (!template) {
      return null;
    }
    return template(domNode, datasourceProps, handlers, onMount);
  }, [datasourceProps, handlers, onMount, spec]);
  (0, _react.useEffect)(() => {
    if (!argument && domNodeRef.current) {
      const arg = callRenderFn(domNodeRef.current);
      if (arg) {
        setArgument(arg);
      }
    }
  }, [argument, callRenderFn]);
  (0, _react.useEffect)(() => {
    if (argument && (prevSpec === null || prevSpec === void 0 ? void 0 : prevSpec.name) !== (spec === null || spec === void 0 ? void 0 : spec.name)) {
      setArgument(undefined);
      datasourceRef.current = undefined;
    }
  }, [argument, prevSpec === null || prevSpec === void 0 ? void 0 : prevSpec.name, spec === null || spec === void 0 ? void 0 : spec.name]);
  (0, _react.useEffect)(() => {
    if (datasourceRef.current) {
      datasourceRef.current.updateProps(datasourceProps);
    }
  }, [datasourceProps]);
  (0, _useEffectOnce.default)(() => {
    datasourceRef.current = undefined;
    return () => {
      datasourceRef.current = undefined;
      handlers.destroy();
    };
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "render_to_dom",
    ref: domNodeRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, argument);
};
const DatasourceWrapper = exports.DatasourceWrapper = /*#__PURE__*/(0, _react.memo)(DatasourceWrapperComponent, (prevProps, nextProps) => (0, _reactFastCompare.default)(prevProps, nextProps));
class Datasource extends _base_form.BaseForm {
  constructor(props) {
    var _props$template;
    super(props);
    (0, _defineProperty2.default)(this, "template", void 0);
    (0, _defineProperty2.default)(this, "image", void 0);
    (0, _defineProperty2.default)(this, "requiresContext", void 0);
    this.template = (_props$template = props.template) !== null && _props$template !== void 0 ? _props$template : defaultTemplate;
    this.image = props.image;
    this.requiresContext = props.requiresContext;
  }
  render(props) {
    const expressionFormHandlers = new _lib.ExpressionFormHandlers();
    return /*#__PURE__*/_react.default.createElement(DatasourceWrapper, {
      spec: this,
      handlers: expressionFormHandlers,
      datasourceProps: props,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 7
      }
    });
  }
}
exports.Datasource = Datasource;