"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearanceForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("../../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/arg_types/container_style/appearance_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  ContainerStyle: strings
} = _i18n.ArgTypesStrings;
const overflows = [{
  value: 'hidden',
  text: strings.getOverflowHiddenOption()
}, {
  value: 'visible',
  text: strings.getOverflowVisibleOption()
}];
const opacities = [{
  value: 1,
  text: '100%'
}, {
  value: 0.9,
  text: '90%'
}, {
  value: 0.7,
  text: '70%'
}, {
  value: 0.5,
  text: '50%'
}, {
  value: 0.3,
  text: '30%'
}, {
  value: 0.1,
  text: '10%'
}];
const AppearanceForm = ({
  padding = '',
  opacity = 1,
  overflow = 'hidden',
  onChange
}) => {
  if (typeof padding === 'string') {
    padding = padding.replace('px', '');
  }
  const namedChange = name => ev => {
    if (name === 'padding') {
      return onChange(name, `${ev.target.value}px`);
    }
    onChange(name, ev.target.value);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "justify-content": "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPaddingLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: Number(padding),
    onChange: namedChange('padding'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getOpacityLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: opacity,
    options: opacities,
    onChange: namedChange('opacity'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getOverflowLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: overflow,
    options: overflows,
    onChange: namedChange('overflow'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }))));
};
exports.AppearanceForm = AppearanceForm;
AppearanceForm.propTypes = {
  padding: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  opacity: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
  overflow: _propTypes.default.oneOf(['hidden', 'visible']),
  onChange: _propTypes.default.func.isRequired
};
AppearanceForm.defaultProps = {
  opacity: 1,
  overflow: 'hidden'
};