"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarSectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/sidebar/sidebar_section_title.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SidebarSectionTitle = ({
  title,
  tip,
  children
}) => {
  const formattedTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    className: "canvasSidebar__panelTitleHeading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 14,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 7
    }
  }, title));
  const renderTitle = () => {
    if (tip) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "left",
        content: tip,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 21,
          columnNumber: 9
        }
      }, formattedTitle);
    }
    return formattedTitle;
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasSidebar__panelTitle",
    gutterSize: "xs",
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, renderTitle(tip)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, children));
};
exports.SidebarSectionTitle = SidebarSectionTitle;
SidebarSectionTitle.propTypes = {
  children: _propTypes.default.node,
  title: _propTypes.default.string,
  tip: _propTypes.default.string
};