"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.copySync = copySync;
exports.createSync = createSync;
exports.ensureDirSync = ensureDirSync;
exports.existsSync = existsSync;
exports.listDirSync = listDirSync;
exports.readSync = readSync;
exports.removeDirSync = removeDirSync;
var _fs = require("fs");
var _path = require("path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function existsSync(path) {
  try {
    (0, _fs.statSync)(path);
    return true;
  } catch (error) {
    if (error.code === 'ENOENT') {
      return false;
    } else {
      throw error;
    }
  }
}
function ensureDirSync(dirPath) {
  const exists = existsSync(dirPath);
  if (!exists) {
    (0, _fs.mkdirSync)(dirPath, {
      recursive: true
    });
  }
}
function createSync(path, content) {
  (0, _fs.writeFileSync)(path, content, {
    encoding: 'utf-8'
  });
}
function copySync(source, destination) {
  // Ensure the destination directory exists
  (0, _fs.mkdirSync)((0, _path.dirname)(destination), {
    recursive: true
  });
  (0, _fs.cpSync)(source, destination, {
    recursive: true
  });
}
function listDirSync(path) {
  return (0, _fs.readdirSync)(path);
}
function readSync(path) {
  return (0, _fs.readFileSync)(path, {
    encoding: 'utf-8'
  });
}
function removeDirSync(path) {
  (0, _fs.rmSync)(path, {
    recursive: true,
    force: true
  });
}