"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionDistribution = TransactionDistribution;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-plugin/common");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_waterfall_fetcher = require("../use_waterfall_fetcher");
var _waterfall_with_summary = require("../waterfall_with_summary");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _duration_distribution_chart_with_scrubber = require("../../../shared/charts/duration_distribution_chart_with_scrubber");
var _resetting_height_container = require("../../../shared/height_retainer/resetting_height_container");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_transaction_distribution_chart_data = require("./use_transaction_distribution_chart_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/distribution/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TransactionDistribution({
  onChartSelection,
  onClearSelection,
  selection,
  traceSamplesFetchResult
}) {
  var _waterfallFetchResult, _traceSamplesFetchRes;
  const {
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    traceId,
    transactionId
  } = urlParams;
  const {
    query: {
      rangeFrom,
      rangeTo,
      showCriticalPath,
      environment
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const history = (0, _reactRouterDom.useHistory)();
  const waterfallFetchResult = (0, _use_waterfall_fetcher.useWaterfallFetcher)({
    traceId,
    transactionId,
    start,
    end
  });
  const {
    waterfallItemId,
    detailTab
  } = urlParams;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const markerCurrentEvent = (_waterfallFetchResult = waterfallFetchResult.waterfall.entryWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.doc.transaction.duration.us;
  const {
    chartData,
    hasData,
    percentileThresholdValue,
    status,
    totalDocCount
  } = (0, _use_transaction_distribution_chart_data.useTransactionDistributionChartData)();
  const onShowCriticalPathChange = (0, _react.useCallback)(nextShowCriticalPath => {
    (0, _url_helpers.push)(history, {
      query: {
        showCriticalPath: nextShowCriticalPath ? 'true' : 'false'
      }
    });
  }, [history]);
  const onTabClick = (0, _react.useCallback)(tab => {
    history.replace({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        detailTab: tab
      })
    });
  }, [history]);
  const onSampleClick = (0, _react.useCallback)(sample => {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        transactionId: sample.transactionId,
        traceId: sample.traceId
      })
    });
  }, [history]);
  return /*#__PURE__*/_react.default.createElement(_resetting_height_container.ResettingHeightRetainer, {
    reset: !traceId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmTransactionDistributionTabContent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_distribution_chart_with_scrubber.DurationDistributionChartWithScrubber, {
    onChartSelection: onChartSelection,
    onClearSelection: onClearSelection,
    selection: selection,
    status: status,
    markerCurrentEvent: markerCurrentEvent,
    chartData: chartData,
    totalDocCount: totalDocCount,
    hasData: hasData,
    percentileThresholdValue: percentileThresholdValue,
    eventType: _common.ProcessorEvent.transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_waterfall_with_summary.WaterfallWithSummary, {
    environment: environment,
    onSampleClick: onSampleClick,
    onTabClick: onTabClick,
    serviceName: serviceName,
    waterfallItemId: waterfallItemId,
    detailTab: detailTab,
    waterfallFetchResult: waterfallFetchResult.waterfall,
    waterfallFetchStatus: waterfallFetchResult.status,
    traceSamplesFetchStatus: traceSamplesFetchResult.status,
    traceSamples: (_traceSamplesFetchRes = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes === void 0 ? void 0 : _traceSamplesFetchRes.traceSamples,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  })));
}