"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceMap = ServiceMap;
exports.ServiceMapHome = ServiceMapHome;
exports.ServiceMapServiceDetail = ServiceMapServiceDetail;
var _ebtTools = require("@kbn/ebt-tools");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _license_check = require("../../../../common/license_check");
var _service_map = require("../../../../common/service_map");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_license_context = require("../../../context/license/use_license_context");
var _license_prompt = require("../../shared/license_prompt");
var _controls = require("./controls");
var _cytoscape = require("./cytoscape");
var _cytoscape_options = require("./cytoscape_options");
var _empty_banner = require("./empty_banner");
var _empty_prompt = require("./empty_prompt");
var _popover = require("./popover");
var _timeout_prompt = require("./timeout_prompt");
var _use_ref_dimensions = require("./use_ref_dimensions");
var _search_bar = require("../../shared/search_bar/search_bar");
var _use_service_name = require("../../../hooks/use_service_name");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _disabled_prompt = require("./disabled_prompt");
var _use_service_map = require("./use_service_map");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PromptContainer({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround"
    // Set the height to give it some top margin
    ,
    style: {
      height: '60vh'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: 600,
      textAlign: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }, children)));
}
function LoadingSpinner() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    style: {
      position: 'absolute',
      top: '50%',
      left: '50%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 10
    }
  });
}
function ServiceMapHome() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      serviceGroup
    }
  } = (0, _use_apm_params.useApmParams)('/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    serviceGroupId: serviceGroup,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}
function ServiceMapServiceDetail() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  return /*#__PURE__*/_react.default.createElement(ServiceMap, {
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 10
    }
  });
}
function ServiceMap({
  environment,
  kuery,
  start,
  end,
  serviceGroupId
}) {
  var _error$body, _error$body2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const license = (0, _use_license_context.useLicenseContext)();
  const serviceName = (0, _use_service_name.useServiceName)();
  const {
    config
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const subscriptions = (0, _react.useRef)(new _rxjs.Subscription());
  (0, _react.useEffect)(() => {
    const currentSubscriptions = subscriptions.current;
    return () => {
      currentSubscriptions.unsubscribe();
    };
  }, []);
  const {
    data,
    status,
    error
  } = (0, _use_service_map.useServiceMap)({
    environment,
    kuery,
    start,
    end,
    serviceGroupId,
    serviceName
  });
  const {
    ref,
    height
  } = (0, _use_ref_dimensions.useRefDimensions)();

  // Temporary hack to work around bottom padding introduced by EuiPage
  const PADDING_BOTTOM = 24;
  const heightWithPadding = height - PADDING_BOTTOM;
  if (!license) {
    return null;
  }
  if (!(0, _license_check.isActivePlatinumLicense)(license)) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      text: _service_map.invalidLicenseMessage,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }));
  }
  if (!config.serviceMapEnabled) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_disabled_prompt.DisabledPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS && data.elements.length === 0) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.FAILURE && error && 'body' in error && ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 500 && ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) === _service_map.SERVICE_MAP_TIMEOUT_ERROR) {
    return /*#__PURE__*/_react.default.createElement(PromptContainer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_timeout_prompt.TimeoutPrompt, {
      isGlobalServiceMap: !serviceName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }));
  }
  if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
    onPageReady({
      customMetrics: {
        key1: 'num_of_nodes',
        value1: data.nodesCount,
        key2: 'num_of_traces',
        value2: data.tracesCount
      },
      meta: {
        rangeFrom: start,
        rangeTo: end
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
    showTimeComparison: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "serviceMap",
    style: {
      height: heightWithPadding
    },
    ref: ref,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cytoscape.Cytoscape, {
    elements: data.elements,
    height: heightWithPadding,
    serviceName: serviceName,
    style: (0, _cytoscape_options.getCytoscapeDivStyle)(euiTheme, status),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_controls.Controls, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }), serviceName && /*#__PURE__*/_react.default.createElement(_empty_banner.EmptyBanner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 29
    }
  }), status === _use_fetcher.FETCH_STATUS.LOADING && /*#__PURE__*/_react.default.createElement(LoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 49
    }
  }), /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    focusedServiceName: serviceName,
    environment: environment,
    kuery: kuery,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })))));
}