"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoResultsFound = NoResultsFound;
exports.SunburstChart = SunburstChart;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _chartIcons = require("@kbn/chart-icons");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _chart_container = require("../../../../shared/charts/chart_container");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/most_used_charts/sunburst_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const theme = {
  chartMargins: {
    top: 0,
    left: 0,
    bottom: 0,
    right: 0
  },
  partition: {
    minFontSize: 5,
    idealFontSizeJump: 1.1,
    outerSizeRatio: 1,
    emptySizeRatio: 0.3,
    circlePadding: 3
  }
};
function SunburstChart({
  data,
  label,
  chartKey,
  fetchStatus,
  chartWidth
}) {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const colors = (0, _eui.euiPaletteColorBlindBehindText)({
    sortBy: 'natural'
  });
  const isDataAvailable = data && data.length > 0;
  const isLoading = fetchStatus === _use_fetcher.FETCH_STATUS.LOADING;

  // The loader needs to be wrapped inside a div with fixed height to avoid layout shift
  const ProgressLoader = /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '5px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    style: {
      background: 'transparent'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 21
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    key: chartKey,
    style: {
      height: '200px',
      width: chartWidth
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    css: (0, _react2.css)`
            font-size: ${(0, _eui.useEuiFontSize)('xs').fontSize};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, label)), ProgressLoader, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: Boolean(isDataAvailable),
    status: fetchStatus,
    height: 200,
    id: `mostUsedChart-${chartKey}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, isDataAvailable ? /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    locale: _i18n.i18n.getLocale(),
    baseTheme: chartBaseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: chartKey,
    data: data,
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => Number(d.docCount),
    valueGetter: "percent",
    layers: [{
      groupByRollup: d => d.key,
      nodeLabel: d => d,
      fillLabel: {
        fontWeight: 100,
        maximizeFontSize: true,
        valueFont: {
          fontWeight: 900
        }
      },
      shape: {
        fillColor: (_, sortIndex) => {
          return colors[sortIndex];
        }
      }
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(NoResultsFound, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  })));
}
const noResultsFoundStyle = (0, _react2.css)({
  height: '100%',
  display: 'flex',
  flexDirection: 'column',
  alignItems: 'center',
  justifyContent: 'center'
});
function NoResultsFound() {
  const noResultsFoundText = _i18n.i18n.translate('xpack.apm.mobile.charts.noResultsFound', {
    defaultMessage: 'No results found'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: noResultsFoundStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "mostUsedNoResultsFound",
    textAlign: "center",
    color: "subdued",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _chartIcons.IconChartDonut,
    color: "subdued",
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }, noResultsFoundText)));
}