"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerGetApmTimeseriesFunction = registerGetApmTimeseriesFunction;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _latency_aggregation_types = require("../../common/latency_aggregation_types");
var _formatters = require("../../common/utils/formatters");
var _get_timeseries_color = require("../components/shared/charts/helper/get_timeseries_color");
var _timezone = require("../components/shared/charts/helper/timezone");
var _timeseries_chart = require("../components/shared/charts/timeseries_chart");
var _helper = require("../components/shared/charts/transaction_charts/helper");
var _chart_pointer_event_context = require("../context/chart_pointer_event/chart_pointer_event_context");
var _use_fetcher = require("../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/assistant_functions/get_apm_timeseries.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerGetApmTimeseriesFunction({
  registerRenderFunction
}) {
  registerRenderFunction('get_apm_timeseries', parameters => {
    const {
      response
    } = parameters;
    const groupedSeries = (0, _lodash.groupBy)(response.data, series => series.group);
    const {
      services: {
        uiSettings
      }
    } = (0, _public.useKibana)();
    const timeZone = (0, _timezone.getTimeZone)(uiSettings);
    return /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }, Object.values(groupedSeries).map(groupSeries => {
      const groupId = groupSeries[0].group;
      const maxY = (0, _helper.getMaxY)(groupSeries);
      const latencyFormatter = (0, _formatters.getDurationFormatter)(maxY, 10, 1000);
      let yLabelFormat;
      const firstStat = groupSeries[0].stat;
      switch (firstStat.timeseries.name) {
        case 'transaction_throughput':
        case 'exit_span_throughput':
        case 'error_event_rate':
          yLabelFormat = _formatters.asTransactionRate;
          break;
        case 'transaction_latency':
        case 'exit_span_latency':
          yLabelFormat = (0, _helper.getResponseTimeTickFormatter)(latencyFormatter);
          break;
        case 'transaction_failure_rate':
        case 'exit_span_failure_rate':
          yLabelFormat = y => (0, _formatters.asPercent)(y || 0, 100);
          break;
      }
      const timeseries = groupSeries.map(series => {
        let chartType;
        const data = series.data;
        switch (series.stat.timeseries.name) {
          case 'transaction_throughput':
          case 'exit_span_throughput':
            chartType = _get_timeseries_color.ChartType.THROUGHPUT;
            break;
          case 'transaction_failure_rate':
          case 'exit_span_failure_rate':
            chartType = _get_timeseries_color.ChartType.FAILED_TRANSACTION_RATE;
            break;
          case 'transaction_latency':
            if (series.stat.timeseries.function === _latency_aggregation_types.LatencyAggregationType.p99) {
              chartType = _get_timeseries_color.ChartType.LATENCY_P99;
            } else if (series.stat.timeseries.function === _latency_aggregation_types.LatencyAggregationType.p95) {
              chartType = _get_timeseries_color.ChartType.LATENCY_P95;
            } else {
              chartType = _get_timeseries_color.ChartType.LATENCY_AVG;
            }
            break;
          case 'exit_span_latency':
            chartType = _get_timeseries_color.ChartType.LATENCY_AVG;
            break;
          case 'error_event_rate':
            chartType = _get_timeseries_color.ChartType.ERROR_OCCURRENCES;
            break;
        }
        return {
          title: series.id,
          type: 'line',
          color: (0, _get_timeseries_color.getTimeSeriesColor)(chartType).currentPeriodColor,
          data
        };
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: groupId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 21
        }
      }, groupId), /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
        comparisonEnabled: false,
        fetchStatus: _use_fetcher.FETCH_STATUS.SUCCESS,
        id: groupId,
        timeZone: timeZone,
        timeseries: timeseries,
        yLabelFormat: yLabelFormat,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 21
        }
      }))));
    })));
  });
}