"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverHistogramLayout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _unifiedHistogram = require("@kbn/unified-histogram");
var _reactReversePortal = require("react-reverse-portal");
var _discover_main_content = require("./discover_main_content");
var _redux = require("../../state_management/redux");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/layout/discover_histogram_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DiscoverHistogramLayout = ({
  panelsToggle,
  ...mainContentProps
}) => {
  const chartPortalNode = (0, _redux.useCurrentChartPortalNode)();
  const {
    localStorageKeyPrefix,
    layoutPropsMap
  } = (0, _redux.useCurrentTabRuntimeState)(mainContentProps.stateContainer.runtimeStateManager, tab => tab.unifiedHistogramConfig$);
  const layoutProps = layoutPropsMap[localStorageKeyPrefix !== null && localStorageKeyPrefix !== void 0 ? localStorageKeyPrefix : _redux.DEFAULT_HISTOGRAM_KEY_PREFIX];
  if (!layoutProps) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_unifiedHistogram.UnifiedHistogramLayout, (0, _extends2.default)({
    unifiedHistogramChart: chartPortalNode ? /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
      node: chartPortalNode,
      panelsToggle: panelsToggle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 27
      }
    }) : null
  }, layoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_discover_main_content.DiscoverMainContent, (0, _extends2.default)({}, mainContentProps, {
    panelsToggle: panelsToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  })));
};
exports.DiscoverHistogramLayout = DiscoverHistogramLayout;