"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBarWarning = ActionBarWarning;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _context = require("../../services/context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/context/components/action_bar/action_bar_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function ActionBarWarning({
  docCount,
  type
}) {
  if (type === _context.SurrDocType.PREDECESSORS) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "primary",
      "data-test-subj": "predecessorsWarningMsg",
      iconType: "info",
      title: docCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.context.newerDocumentsWarningZero",
        defaultMessage: "No documents newer than the anchor could be found.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 24,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.context.newerDocumentsWarning",
        defaultMessage: "Only {docCount} documents newer than the anchor could be found.",
        values: {
          docCount
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 13
        }
      }),
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "successorsWarningMsg",
    iconType: "info",
    title: docCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.olderDocumentsWarningZero",
      defaultMessage: "No documents older than the anchor could be found.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.olderDocumentsWarning",
      defaultMessage: "Only {docCount} documents older than the anchor could be found.",
      values: {
        docCount
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }),
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
}