"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditComponentTemplateLink = CreateEditComponentTemplateLink;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("@kbn/deeplinks-management/constants");
var _eui = require("@elastic/eui");
var _utils = require("../../../../../../utils");
var _hooks = require("../../../../../../hooks");
var _component_template_name = require("../../../../../../../common/utils/component_template_name");
var _translations = require("../../../../../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/possible_mitigations/manual/component_template_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateEditComponentTemplateLink({
  areIntegrationAssetsAvailable
}) {
  const {
    services: {
      application,
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const [indexTemplatePath, setIndexTemplatePath] = (0, _react.useState)(null);
  const [componentTemplatePath, setComponentTemplatePath] = (0, _react.useState)(null);
  const {
    dataStreamSettings,
    datasetDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    name
  } = datasetDetails;
  const indexManagementLocator = locators.get('INDEX_MANAGEMENT_LOCATOR_ID');
  (0, _react.useEffect)(() => {
    var _dataStreamSettings$i, _dataStreamSettings$i2;
    indexManagementLocator === null || indexManagementLocator === void 0 ? void 0 : indexManagementLocator.getLocation({
      page: 'index_template',
      indexTemplate: (_dataStreamSettings$i = dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.indexTemplate) !== null && _dataStreamSettings$i !== void 0 ? _dataStreamSettings$i : ''
    }).then(({
      path
    }) => setIndexTemplatePath(path));
    indexManagementLocator === null || indexManagementLocator === void 0 ? void 0 : indexManagementLocator.getLocation({
      page: 'component_template',
      componentTemplate: `${(0, _component_template_name.getComponentTemplatePrefixFromIndexTemplate)((_dataStreamSettings$i2 = dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.indexTemplate) !== null && _dataStreamSettings$i2 !== void 0 ? _dataStreamSettings$i2 : name)}@custom`
    }).then(({
      path
    }) => setComponentTemplatePath(path));
  }, [locators, setIndexTemplatePath, dataStreamSettings === null || dataStreamSettings === void 0 ? void 0 : dataStreamSettings.indexTemplate, indexManagementLocator, name]);
  const templateUrl = areIntegrationAssetsAvailable ? componentTemplatePath : indexTemplatePath;
  const onClickHandler = (0, _react.useCallback)(async () => {
    const options = {
      openInNewTab: true,
      ...(templateUrl && {
        path: templateUrl
      })
    };
    await application.navigateToApp(_constants.MANAGEMENT_APP_ID, options);
  }, [application, templateUrl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "datasetQualityManualMitigationsCustomComponentTemplateLink",
    "data-test-url": templateUrl,
    onClick: onClickHandler,
    target: "_blank",
    color: "primary",
    css: {
      width: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), _translations.otherMitigationsCustomComponentTemplate)));
}