"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNav = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _footer = require("./footer");
var _footer_item = require("./footer_item");
var _logo = require("./logo");
var _panel = require("./panel");
var _popover = require("../popover");
var _primary_menu = require("./primary_menu");
var _primary_menu_item = require("./primary_menu_item");
var _use_layout_width = require("../../hooks/use_layout_width");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SideNav = ({
  children,
  isCollapsed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement("div", {
    className: "side-nav",
    css: (0, _react.css)`
        box-sizing: border-box;
        background-color: ${euiTheme.colors.backgroundBasePlain};
        border-right: ${euiTheme.border.width.thin} solid ${euiTheme.colors.borderBaseSubdued};
        display: flex;
        flex-direction: column;
        gap: ${isCollapsed ? euiTheme.size.s : euiTheme.size.m};
        height: 100%;
        padding-bottom: ${euiTheme.size.base};
        width: ${isCollapsed ? _use_layout_width.COLLAPSED_WIDTH : _use_layout_width.EXPANDED_WIDTH}px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, children);
};
exports.SideNav = SideNav;
SideNav.Logo = _logo.SideNavLogoComponent;
SideNav.PrimaryMenu = _primary_menu.SideNavPrimaryMenu;
SideNav.PrimaryMenuItem = _primary_menu_item.SideNavPrimaryMenuItem;
SideNav.Popover = _popover.SideNavPopover;
SideNav.Footer = _footer.SideNavFooter;
SideNav.FooterItem = _footer_item.SideNavFooterItem;
SideNav.Panel = _panel.SideNavPanel;