"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavFooter = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SideNavFooter = ({
  children,
  isCollapsed
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (
    /*#__PURE__*/
    // The footer itself is not interactive but the children are
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("footer", {
      "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.footerAriaLabel', {
        defaultMessage: 'Side navigation'
      }),
      css: (0, _react2.css)`
        align-items: center;
        border-top: 1px solid ${euiTheme.colors.borderBaseSubdued};
        display: flex;
        flex-direction: column;
        gap: ${euiTheme.size.xs};
        justify-content: center;
        padding-top: ${isCollapsed ? euiTheme.size.s : euiTheme.size.m};
      `,
      onKeyDown: _handle_roving_index.handleRovingIndex,
      ref: ref => {
        if (ref) {
          const elements = (0, _get_focusable_elements.getFocusableElements)(ref);
          (0, _update_tab_indices.updateTabIndices)(elements);
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 5
      }
    }, children)
  );
};
exports.SideNavFooter = SideNavFooter;