"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppContainer = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _coreApplicationBrowser = require("@kbn/core-application-browser");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
var _app_not_found_screen = require("./app_not_found_screen");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/application/browser-internal/src/ui/app_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AppContainer = ({
  mounter,
  appId,
  appPath,
  setAppLeaveHandler,
  setAppActionMenu,
  createScopedHistory,
  appStatus,
  setIsMounting,
  theme$,
  showPlainSpinner
}) => {
  const [error, setError] = (0, _react2.useState)(null);
  const [showSpinner, setShowSpinner] = (0, _react2.useState)(true);
  const [appNotFound, setAppNotFound] = (0, _react2.useState)(false);
  const elementRef = (0, _react2.useRef)(null);
  const unmountRef = (0, _react2.useRef)(null);
  (0, _react2.useLayoutEffect)(() => {
    const unmount = () => {
      if (unmountRef.current) {
        unmountRef.current();
        unmountRef.current = null;
      }
    };
    if (!mounter || appStatus !== _coreApplicationBrowser.AppStatus.accessible) {
      return setAppNotFound(true);
    }
    setAppNotFound(false);
    setIsMounting(true);
    if (mounter.unmountBeforeMounting) {
      unmount();
    }
    const mount = async () => {
      setShowSpinner(true);
      try {
        unmountRef.current = (await mounter.mount({
          appBasePath: mounter.appBasePath,
          history: createScopedHistory(appPath),
          element: elementRef.current,
          theme$,
          onAppLeave: handler => setAppLeaveHandler(appId, handler),
          setHeaderActionMenu: menuMount => setAppActionMenu(appId, menuMount)
        })) || null;
      } catch (e) {
        setError(e);
        // eslint-disable-next-line no-console
        console.error(e);
      } finally {
        if (elementRef.current) {
          setShowSpinner(false);
        }
        setIsMounting(false);
      }
    };
    mount();
    return unmount;
  }, [appId, appStatus, mounter, createScopedHistory, setAppLeaveHandler, setAppActionMenu, appPath, setIsMounting, theme$]);
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxErrorBoundary.ThrowIfError, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }), appNotFound && /*#__PURE__*/_react2.default.createElement(_app_not_found_screen.AppNotFound, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 23
    }
  }), showSpinner && !appNotFound && /*#__PURE__*/_react2.default.createElement(AppLoadingPlaceholder, {
    showPlainSpinner: Boolean(showPlainSpinner),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    className: _coreApplicationCommon.APP_WRAPPER_CLASS,
    key: appId,
    ref: elementRef,
    "aria-busy": showSpinner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }));
};
exports.AppContainer = AppContainer;
const AppLoadingPlaceholder = ({
  showPlainSpinner
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const appContainerFadeIn = (0, _react.keyframes)({
    '0%': {
      opacity: 0
    },
    '50%': {
      opacity: 0
    },
    '100%': {
      opacity: 1
    }
  });
  const appContainerStyles = (0, _react.css)({
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    zIndex: euiTheme.levels.header,
    animationName: appContainerFadeIn,
    animationIterationCount: 1,
    animationTimingFunction: 'ease-in',
    animationDuration: '2s'
  });
  if (showPlainSpinner) {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingSpinner, {
      size: 'xxl',
      css: appContainerStyles,
      "data-test-subj": "appContainer-loadingSpinner",
      "aria-label": _i18n.i18n.translate('core.application.appContainer.plainSpinner.loadingAriaLabel', {
        defaultMessage: 'Loading application'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingElastic, {
    css: appContainerStyles,
    "aria-label": _i18n.i18n.translate('core.application.appContainer.loadingAriaLabel', {
      defaultMessage: 'Loading application'
    }),
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  });
};